/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.execution.context;

import graphql.schema.DataFetchingEnvironment;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.osgi.framework.BundleContext;

public final class OpencastContextManager {
    public static final String CONTEXT = "context";
    private static final InheritableThreadLocal<OpencastContext> contextHolder = new InheritableThreadLocal();

    private OpencastContextManager() {
    }

    public static OpencastContext initiateContext(BundleContext bundleContext) {
        OpencastContext context = OpencastContextManager.getCurrentContext();
        if (context == null) {
            context = OpencastContext.newContext(bundleContext);
        }
        contextHolder.set(context);
        return context;
    }

    public static OpencastContext restoreContext(DataFetchingEnvironment environment) {
        OpencastContext context = (OpencastContext)environment.getGraphQlContext().get((Object)CONTEXT);
        contextHolder.set(context);
        return context;
    }

    public static OpencastContext getCurrentContext() {
        return (OpencastContext)contextHolder.get();
    }

    public static OpencastContext enrichContext(DataFetchingEnvironment environment) {
        OpencastContext context = OpencastContextManager.getCurrentContext();
        if (context == null) {
            context = OpencastContextManager.restoreContext(environment);
        }
        environment.getGraphQlContext().put((Object)CONTEXT, (Object)context);
        contextHolder.set(context);
        return context;
    }

    public static void clearContext() {
        contextHolder.remove();
    }
}

