/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.execution.context;

import java.util.Map;
import java.util.Objects;
import org.opencastproject.graphql.config.GraphQLConfiguration;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.User;
import org.osgi.framework.BundleContext;

public class OpencastContext {
    private BundleContext bundleContext;
    private Map<String, Object> arguments;
    private Organization organization;
    private User user;

    public <T> T getService(Class<T> clazz) {
        return (T)this.bundleContext.getService(this.bundleContext.getServiceReference(clazz));
    }

    public GraphQLConfiguration getConfiguration() {
        return this.getService(GraphQLConfiguration.class);
    }

    public static OpencastContext newContext(BundleContext bundleContext) {
        OpencastContext context = new OpencastContext();
        context.setBundleContext(bundleContext);
        return context;
    }

    protected void setBundleContext(BundleContext bundleContext) {
        Objects.requireNonNull(bundleContext, "OSGi bundle context cannot be null");
        this.bundleContext = bundleContext;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}

