/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.execution;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import graphql.ExecutionInput;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class QueryCache
implements PreparsedDocumentProvider {
    private final Cache<String, PreparsedDocumentEntry> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(2048L).build();

    public PreparsedDocumentEntry getDocument(ExecutionInput executionInput, Function<ExecutionInput, PreparsedDocumentEntry> parseAndValidateFunction) {
        try {
            return this.getDocumentAsync(executionInput, parseAndValidateFunction).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<PreparsedDocumentEntry> getDocumentAsync(ExecutionInput executionInput, Function<ExecutionInput, PreparsedDocumentEntry> parseAndValidateFunction) {
        return CompletableFuture.completedFuture((PreparsedDocumentEntry)this.cache.get((Object)executionInput.getQuery(), key -> (PreparsedDocumentEntry)parseAndValidateFunction.apply(executionInput)));
    }
}

