/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.execution;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;

public class OpencastDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(DataFetcherExceptionHandlerParameters handlerParameters) {
        return CompletableFuture.completedFuture(this.handleExceptionImpl(handlerParameters));
    }

    private DataFetcherExceptionHandlerResult handleExceptionImpl(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable exception = this.unwrap(handlerParameters.getException());
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ResultPath path = handlerParameters.getPath();
        ExceptionWhileDataFetching error = new ExceptionWhileDataFetching(path, exception, sourceLocation);
        return DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build();
    }

    protected Throwable unwrap(Throwable exception) {
        if (exception.getCause() != null && exception instanceof RuntimeException) {
            if (exception.getCause() instanceof InvocationTargetException) {
                return ((InvocationTargetException)exception.getCause()).getTargetException();
            }
            return exception.getCause();
        }
        return exception;
    }
}

