/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.analysis.MaxQueryDepthInstrumentation;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.tracing.TracingInstrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.execution.ExecutionErrorResult;
import org.opencastproject.graphql.execution.OpencastDataFetcherExceptionHandler;
import org.opencastproject.graphql.execution.OrganizationExecutionIdProvider;
import org.opencastproject.graphql.execution.QueryCache;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.schema.SchemaService;
import org.opencastproject.security.api.SecurityService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ExecutionService.class})
public class ExecutionService {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionService.class);
    private final SecurityService securityService;
    private final SchemaService schemaService;
    private final BundleContext bundleContext;
    private final Map<String, GraphQL> organizationGraphQL = new ConcurrentHashMap<String, GraphQL>();
    private ExecutionConfiguration config;

    @Activate
    public ExecutionService(@Reference SchemaService schemaService, @Reference SecurityService securityService, BundleContext bundleContext, ExecutionConfiguration config) {
        this.schemaService = schemaService;
        this.securityService = securityService;
        this.bundleContext = bundleContext;
        this.updateConfiguration(config);
    }

    @Modified
    public void updateConfiguration(ExecutionConfiguration config) {
        if (config.execution_max_query_complexity() <= 0) {
            throw new IllegalArgumentException("execution_max_query_complexity must be greater than 0");
        }
        if (config.execution_max_query_depth() <= 0) {
            throw new IllegalArgumentException("execution_max_query_depth must be greater than 0");
        }
        this.config = config;
    }

    public ExecutionResult execute(String query, String operationName, Map<String, Object> variables, Map<String, Object> extensions) {
        HashMap context = new HashMap();
        return this.execute(ExecutionInput.newExecutionInput().query(query).operationName(operationName).variables(variables != null ? variables : Collections.emptyMap()).extensions(extensions != null ? extensions : Collections.emptyMap()).graphQLContext(context).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(ExecutionInput executionInput) {
        try {
            OpencastContext context = OpencastContextManager.initiateContext(this.bundleContext);
            context.setOrganization(this.securityService.getOrganization());
            context.setUser(this.securityService.getUser());
            executionInput.getGraphQLContext().put((Object)"context", (Object)context);
            GraphQL graphQL = this.getGraphQL(this.securityService.getOrganization().getId());
            if (graphQL == null) {
                ExecutionResult executionResult = ExecutionErrorResult.newExecutionResult().addError(new GraphQLNotFoundException("No GraphQL schema found for organization `" + this.securityService.getOrganization().getId() + "`")).build();
                return executionResult;
            }
            ExecutionResult executionResult = graphQL.execute(executionInput);
            return executionResult;
        }
        finally {
            OpencastContextManager.clearContext();
        }
    }

    private GraphQL getGraphQL(String organizationId) {
        GraphQL graphQL = this.organizationGraphQL.get(organizationId);
        GraphQLSchema schema = this.schemaService.get(organizationId);
        ArrayList<MaxQueryComplexityInstrumentation> chainedList = new ArrayList<MaxQueryComplexityInstrumentation>(List.of(new MaxQueryDepthInstrumentation(this.config.execution_max_query_depth()), new MaxQueryComplexityInstrumentation(this.config.execution_max_query_complexity())));
        if (logger.isTraceEnabled()) {
            logger.trace("Enabling tracing instrumentation for organization `{}`", (Object)organizationId);
            chainedList.add((MaxQueryComplexityInstrumentation)new TracingInstrumentation());
        }
        if (schema == null) {
            return null;
        }
        if (graphQL == null || !schema.equals(graphQL.getGraphQLSchema())) {
            OpencastDataFetcherExceptionHandler exceptionHandler = new OpencastDataFetcherExceptionHandler();
            graphQL = GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy((DataFetcherExceptionHandler)exceptionHandler)).mutationExecutionStrategy((ExecutionStrategy)new AsyncSerialExecutionStrategy((DataFetcherExceptionHandler)exceptionHandler)).preparsedDocumentProvider((PreparsedDocumentProvider)new QueryCache()).executionIdProvider((ExecutionIdProvider)new OrganizationExecutionIdProvider(organizationId)).defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)exceptionHandler).instrumentation((Instrumentation)new ChainedInstrumentation(chainedList)).build();
            this.organizationGraphQL.put(organizationId, graphQL);
        }
        return graphQL;
    }

    public static @interface ExecutionConfiguration {
        public int execution_max_query_complexity() default 1000;

        public int execution_max_query_depth() default 25;
    }
}

