/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.execution;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecutionErrorResult
implements ExecutionResult {
    private final List<GraphQLError> errors;
    private final Map<Object, Object> extensions;

    public ExecutionErrorResult(List<GraphQLError> errors) {
        this(errors, null);
    }

    public ExecutionErrorResult(List<GraphQLError> errors, Map<Object, Object> extensions) {
        this.errors = errors;
        this.extensions = extensions;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public <T> T getData() {
        return null;
    }

    public boolean isDataPresent() {
        return false;
    }

    public Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    public Map<String, Object> toSpecification() {
        return null;
    }

    public static Builder newExecutionResult() {
        return new Builder();
    }

    public static class Builder
    implements ExecutionResult.Builder<Builder> {
        private List<GraphQLError> errors = new ArrayList<GraphQLError>();
        private Map<Object, Object> extensions;

        public Builder from(ExecutionResult executionResult) {
            this.errors = new ArrayList<GraphQLError>(executionResult.getErrors());
            this.extensions = executionResult.getExtensions();
            return this;
        }

        public Builder data(Object data) {
            throw new UnsupportedOperationException("Cannot set data on an error result");
        }

        public Builder errors(List<GraphQLError> errors) {
            this.errors = errors;
            return this;
        }

        public Builder addErrors(List<GraphQLError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Builder addError(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        public Builder extensions(Map<Object, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder addExtension(String key, Object value) {
            this.extensions = this.extensions == null ? new LinkedHashMap() : this.extensions;
            this.extensions.put(key, value);
            return this;
        }

        public ExecutionResult build() {
            return new ExecutionErrorResult(this.errors, this.extensions);
        }
    }
}

