/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.exception;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.List;
import java.util.Map;
import org.opencastproject.graphql.exception.OpencastErrorType;

public class GraphQLRuntimeException
extends RuntimeException
implements GraphQLError {
    private static final long serialVersionUID = 7752209655703366697L;
    private final OpencastErrorType errorType;
    private Map<String, Object> extensions;

    public GraphQLRuntimeException(OpencastErrorType errorType) {
        this.errorType = errorType;
    }

    public GraphQLRuntimeException(String message, OpencastErrorType errorType) {
        super(message);
        this.errorType = errorType;
    }

    public GraphQLRuntimeException(String message, OpencastErrorType errorType, Throwable cause) {
        super(message, cause);
        this.errorType = errorType;
    }

    public GraphQLRuntimeException(String message, Map<String, Object> extensions, Throwable cause) {
        super(message, cause);
        this.errorType = OpencastErrorType.Undefined;
        this.extensions = extensions;
    }

    public GraphQLRuntimeException(String message, OpencastErrorType errorType, Map<String, Object> extensions, Throwable cause) {
        super(message, cause);
        this.errorType = errorType;
        this.extensions = extensions;
    }

    public GraphQLRuntimeException(Throwable cause) {
        super(cause);
        this.errorType = OpencastErrorType.InternalError;
    }

    public GraphQLRuntimeException(OpencastErrorType errorType, Throwable cause) {
        super(cause);
        this.errorType = errorType;
    }

    public List<SourceLocation> getLocations() {
        return null;
    }

    public ErrorClassification getErrorType() {
        return this.errorType;
    }

    public List<Object> getPath() {
        return super.getPath();
    }

    public Map<String, Object> toSpecification() {
        return super.toSpecification();
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }
}

