/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.event;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.type.output.OffsetPageInfo;

@GraphQLName(value="EventList")
@GraphQLNonNull
@GraphQLDescription(value="A list of events")
public class GqlEventList {
    public static final String TYPE_NAME = "EventList";
    protected final SearchResult<Event> searchResult;

    public GqlEventList(SearchResult<Event> searchResult) {
        this.searchResult = searchResult;
    }

    @GraphQLField
    @GraphQLNonNull
    public Long totalCount() {
        return this.searchResult.getHitCount();
    }

    @GraphQLField
    @GraphQLNonNull
    public OffsetPageInfo pageInfo() {
        return OffsetPageInfo.from(this.searchResult);
    }

    @GraphQLField
    @GraphQLNonNull
    public List<GqlEvent> nodes() {
        return Arrays.stream(this.searchResult.getItems()).map(SearchResultItem::getSource).map(GqlEvent::new).collect(Collectors.toList());
    }
}

