/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.event;

import graphql.annotations.annotationTypes.GraphQLDataFetcher;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLType;
import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.datafetcher.event.CommonEventMetadataDataFetcher;
import org.opencastproject.graphql.datafetcher.event.CommonEventMetadataV2DataFetcher;
import org.opencastproject.graphql.datafetcher.series.SeriesDataFetcher;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.DateTimeFunction;
import org.opencastproject.graphql.type.DurationFunction;
import org.opencastproject.graphql.type.output.GqlCommonEventMetadata;
import org.opencastproject.graphql.type.output.GqlCommonEventMetadataV2;
import org.opencastproject.graphql.type.output.GqlPublication;
import org.opencastproject.workflow.api.WorkflowService;

@GraphQLName(value="Event")
@GraphQLDescription(value="A Event.")
public class GqlEvent {
    public static final String TYPE_NAME = "Event";
    private final Event event;

    public GqlEvent(Event event) {
        this.event = event;
    }

    @GraphQLField
    public @GraphQLID @GraphQLNonNull String id() {
        return this.event.getIdentifier();
    }

    @GraphQLField
    @GraphQLNonNull
    public String title() {
        return this.event.getTitle();
    }

    @GraphQLField
    public String description() {
        return this.event.getDescription();
    }

    @GraphQLField
    public List<String> presenters() {
        return this.event.getPresenters();
    }

    @GraphQLField
    public List<String> contributors() {
        return this.event.getContributors();
    }

    @GraphQLField
    public String publisher() {
        return this.event.getPublisher();
    }

    @GraphQLField
    public String location() {
        return this.event.getLocation();
    }

    @GraphQLField
    public String license() {
        return this.event.getLicense();
    }

    @GraphQLField
    public String creator() {
        return this.event.getCreator();
    }

    @GraphQLField
    @GraphQLType(value=DateTimeFunction.class)
    public String created() {
        return this.event.getCreated();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLType(value=DurationFunction.class)
    public Long duration() {
        return this.event.getDuration();
    }

    @GraphQLField
    @GraphQLType(value=DateTimeFunction.class)
    public String startDate() {
        return this.event.getRecordingStartDate();
    }

    @GraphQLField
    @GraphQLType(value=DateTimeFunction.class)
    public String endDate() {
        return this.event.getRecordingEndDate();
    }

    @GraphQLField
    public String technicalStartTime() {
        return this.event.getTechnicalStartTime();
    }

    @GraphQLField
    public String technicalEndTime() {
        return this.event.getTechnicalEndTime();
    }

    @GraphQLField
    @GraphQLNonNull
    public String eventStatus() {
        return this.event.getEventStatus();
    }

    @GraphQLField
    public String displayableStatus() {
        WorkflowService workflowService = OpencastContextManager.getCurrentContext().getService(WorkflowService.class);
        if (workflowService != null) {
            return this.event.getDisplayableStatus(workflowService.getWorkflowStateMappings());
        }
        return null;
    }

    @GraphQLField
    @GraphQLDescription(value="Return publications filterable by channel and tags")
    public List<GqlPublication> publications(@GraphQLName(value="channel") String channel, @GraphQLName(value="tags") List<String> tags) {
        return this.event.getPublications().stream().filter(e -> !Objects.equals(e.getChannel(), "internal")).filter(e -> channel == null || Objects.equals(e.getChannel(), channel)).filter(e -> {
            if (tags == null) return true;
            if (!Arrays.stream(e.getTags()).anyMatch(tags::contains)) return false;
            return true;
        }).map(GqlPublication::new).collect(Collectors.toList());
    }

    @GraphQLField
    public String seriesId() {
        return this.event.getSeriesId();
    }

    @GraphQLField
    public String seriesName() {
        return this.event.getSeriesName();
    }

    @GraphQLField
    public GqlSeries series(DataFetchingEnvironment environment) {
        String seriesId = this.event.getSeriesId();
        if (seriesId == null) {
            return null;
        }
        return (GqlSeries)new SeriesDataFetcher(this.event.getSeriesId()).get(environment);
    }

    @GraphQLField
    @GraphQLNonNull
    public Boolean hasPreview() {
        return this.event.hasPreview();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Common metadata of the event.")
    @GraphQLDataFetcher(value=CommonEventMetadataDataFetcher.class)
    public GqlCommonEventMetadata commonMetadata(DataFetchingEnvironment environment) {
        return null;
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Common metadata of the event.")
    @GraphQLDataFetcher(value=CommonEventMetadataV2DataFetcher.class)
    public GqlCommonEventMetadataV2 commonMetadataV2(DataFetchingEnvironment environment) {
        return null;
    }

    public Event getEvent() {
        return this.event;
    }
}

