/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.event;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import org.opencastproject.graphql.datafetcher.event.EventDataFetcher;
import org.opencastproject.graphql.datafetcher.event.EventOffsetDataFetcher;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.event.GqlEventList;
import org.opencastproject.graphql.type.input.EventFilterByInput;
import org.opencastproject.graphql.type.input.EventOrderByInput;
import org.opencastproject.graphql.type.output.Query;

@GraphQLTypeExtension(value=Query.class)
public final class EventQueryExtension {
    private EventQueryExtension() {
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Returns event list")
    public static GqlEventList allEvents(@GraphQLName(value="limit") Integer limit, @GraphQLName(value="offset") Integer offset, @GraphQLName(value="query") String query, @GraphQLName(value="orderBy") EventOrderByInput orderBy, @GraphQLName(value="filterBy") EventFilterByInput filterBy, DataFetchingEnvironment environment) {
        return (GqlEventList)new EventOffsetDataFetcher().get(environment);
    }

    @GraphQLField
    @GraphQLDescription(value="Returns a event by id")
    public static GqlEvent eventById(@GraphQLName(value="id") @GraphQLNonNull String id, DataFetchingEnvironment environment) {
        return (GqlEvent)new EventDataFetcher(id).get(environment);
    }
}

