/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.user;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.graphql.datafetcher.ParameterDataFetcher;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.user.GqlUserList;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.util.SmartIterator;

public class UserOffsetDataFetcher
extends ParameterDataFetcher<GqlUserList> {
    private String filter;

    public UserOffsetDataFetcher withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public GqlUserList get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        UserDirectoryService userDirectoryService = opencastContext.getService(UserDirectoryService.class);
        Integer limit = this.parseParam("limit", 1000, dataFetchingEnvironment);
        Integer offset = this.parseParam("offset", 0, dataFetchingEnvironment);
        List<Object> filteredUsers = new ArrayList<User>();
        for (User user : userDirectoryService.getUsers()) {
            if (this.filter != null && !UserOffsetDataFetcher.match(this.filter, user.getUsername(), user.getName(), user.getEmail(), user.getProvider())) continue;
            filteredUsers.add(user);
        }
        int total = filteredUsers.size();
        filteredUsers = new SmartIterator(limit.intValue(), offset.intValue()).applyLimitAndOffset(filteredUsers);
        ArrayList<User> result = new ArrayList<User>(filteredUsers);
        return new GqlUserList(result, Long.valueOf(total), (long)offset, (long)limit);
    }

    public static boolean match(String searchStrings, String ... text) {
        for (String searchString : StringUtils.split((String)searchStrings)) {
            for (String word : text) {
                if (StringUtils.indexOfIgnoreCase((CharSequence)word, (CharSequence)searchString) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

