/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.series;

import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.graphql.datafetcher.ElasticsearchDataFetcher;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.OpencastErrorType;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.series.GqlSeriesList;
import org.opencastproject.graphql.type.input.SeriesOrderByInput;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;

public class SeriesOffsetDataFetcher
extends ElasticsearchDataFetcher<GqlSeriesList> {
    private User user;
    private boolean writeOnly;

    public SeriesOffsetDataFetcher withUser(User user) {
        this.user = user;
        return this;
    }

    public SeriesOffsetDataFetcher writeOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    @Override
    public GqlSeriesList get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        SecurityService securityService = opencastContext.getService(SecurityService.class);
        ElasticsearchIndex searchIndex = opencastContext.getService(ElasticsearchIndex.class);
        SeriesSearchQuery seriesSearchQuery = new SeriesSearchQuery(securityService.getOrganization().getId(), Objects.requireNonNullElse(this.user, securityService.getUser()));
        seriesSearchQuery = this.addPaginationParams(seriesSearchQuery, dataFetchingEnvironment);
        seriesSearchQuery = this.addSeriesOrderByParams(seriesSearchQuery, dataFetchingEnvironment);
        seriesSearchQuery = this.addQueryParams(seriesSearchQuery, dataFetchingEnvironment);
        if (this.writeOnly) {
            seriesSearchQuery.withAction(Permissions.Action.WRITE);
        }
        try {
            SearchResult result = searchIndex.getByQuery(seriesSearchQuery);
            return new GqlSeriesList((SearchResult<Series>)result);
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(OpencastErrorType.InternalError, (Throwable)e);
        }
    }

    public SeriesSearchQuery addSeriesOrderByParams(SeriesSearchQuery seriesSearchQuery, DataFetchingEnvironment environment) {
        SeriesOrderByInput seriesOrderBy = this.parseObjectParam("orderBy", SeriesOrderByInput.class, environment);
        if (seriesOrderBy == null) {
            return seriesSearchQuery;
        }
        if (seriesOrderBy.getTitle() != null) {
            seriesSearchQuery.sortByTitle(seriesOrderBy.getTitle().getOrder());
        }
        if (seriesOrderBy.getSubject() != null) {
            seriesSearchQuery.sortBySubject(seriesOrderBy.getSubject().getOrder());
        }
        if (seriesOrderBy.getCreator() != null) {
            seriesSearchQuery.sortByCreator(seriesOrderBy.getCreator().getOrder());
        }
        if (seriesOrderBy.getPublishers() != null) {
            seriesSearchQuery.sortByPublishers(seriesOrderBy.getPublishers().getOrder());
        }
        if (seriesOrderBy.getContributors() != null) {
            seriesSearchQuery.sortByContributors(seriesOrderBy.getContributors().getOrder());
        }
        if (seriesOrderBy.getDescription() != null) {
            seriesSearchQuery.sortByDescription(seriesOrderBy.getDescription().getOrder());
        }
        if (seriesOrderBy.getLanguage() != null) {
            seriesSearchQuery.sortByLanguage(seriesOrderBy.getLanguage().getOrder());
        }
        if (seriesOrderBy.getRightHolder() != null) {
            seriesSearchQuery.sortByRightsHolder(seriesOrderBy.getRightHolder().getOrder());
        }
        if (seriesOrderBy.getLicense() != null) {
            seriesSearchQuery.sortByLicense(seriesOrderBy.getLicense().getOrder());
        }
        if (seriesOrderBy.getCreated() != null) {
            seriesSearchQuery.sortByCreatedDateTime(seriesOrderBy.getCreated().getOrder());
        }
        return seriesSearchQuery;
    }
}

