/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.series;

import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.graphql.datafetcher.ContextDataFetcher;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.OpencastErrorType;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.security.api.SecurityService;

public class SeriesDataFetcher
implements ContextDataFetcher<GqlSeries> {
    private final String seriesId;

    public SeriesDataFetcher(String seriesId) {
        Objects.requireNonNull(seriesId, "Series identifier must not be null.");
        this.seriesId = seriesId;
    }

    @Override
    public GqlSeries get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        SecurityService securityService = opencastContext.getService(SecurityService.class);
        ElasticsearchIndex searchIndex = opencastContext.getService(ElasticsearchIndex.class);
        try {
            SearchResult result = searchIndex.getByQuery(new SeriesSearchQuery(securityService.getOrganization().getId(), securityService.getUser()).withIdentifier(this.seriesId));
            if (result.getDocumentCount() == 0L) {
                return null;
            }
            if (result.getDocumentCount() == 1L) {
                return new GqlSeries((Series)result.getItems()[0].getSource());
            }
            throw new GraphQLRuntimeException("Multiple series found with the same identifier", OpencastErrorType.InternalError);
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(OpencastErrorType.InternalError, (Throwable)e);
        }
    }
}

