/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.series;

import com.entwinemedia.fn.data.Opt;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.Map;
import org.opencastproject.graphql.datafetcher.ContextDataFetcher;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.output.GqlMetadataFieldInterface;
import org.opencastproject.graphql.util.MetadataFieldToGraphQLFieldMapper;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;

public class CommonSeriesMetadataV2DataFetcher
implements ContextDataFetcher<Map<String, GqlMetadataFieldInterface>> {
    @Override
    public Map<String, GqlMetadataFieldInterface> get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        String seriesId = ((GqlSeries)dataFetchingEnvironment.getSource()).id();
        IndexService indexService = opencastContext.getService(IndexService.class);
        HashMap<String, GqlMetadataFieldInterface> result = new HashMap<String, GqlMetadataFieldInterface>();
        Opt optSeries = indexService.getCommonSeriesCatalogUIAdapter().getFields(seriesId);
        if (optSeries.isNone()) {
            throw new GraphQLNotFoundException("Series with id `" + seriesId + "` not found.");
        }
        ((DublinCoreMetadataCollection)optSeries.get()).getOutputFields().forEach((key, value) -> result.put((String)key, MetadataFieldToGraphQLFieldMapper.mapType(value)));
        return result;
    }
}

