/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.event;

import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.Objects;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.graphql.datafetcher.ElasticsearchDataFetcher;
import org.opencastproject.graphql.event.GqlEventList;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.OpencastErrorType;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.type.input.EventFilterByInput;
import org.opencastproject.graphql.type.input.EventOrderByInput;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;

public class EventOffsetDataFetcher
extends ElasticsearchDataFetcher<GqlEventList> {
    private User user;
    private String seriesId;
    private boolean writeOnly;

    public EventOffsetDataFetcher withUser(User user) {
        this.user = user;
        return this;
    }

    public EventOffsetDataFetcher withSeriesId(String seriesId) {
        this.seriesId = seriesId;
        return this;
    }

    public EventOffsetDataFetcher writeOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    @Override
    public GqlEventList get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        SecurityService securityService = opencastContext.getService(SecurityService.class);
        ElasticsearchIndex searchIndex = opencastContext.getService(ElasticsearchIndex.class);
        EventSearchQuery eventSearchQuery = new EventSearchQuery(securityService.getOrganization().getId(), Objects.requireNonNullElse(this.user, securityService.getUser()));
        eventSearchQuery = this.addPaginationParams(eventSearchQuery, dataFetchingEnvironment);
        eventSearchQuery = this.addEventOrderByParams(eventSearchQuery, dataFetchingEnvironment);
        eventSearchQuery = this.addEventFilterByParams(eventSearchQuery, dataFetchingEnvironment);
        eventSearchQuery = this.addQueryParams(eventSearchQuery, dataFetchingEnvironment);
        if (this.seriesId != null) {
            eventSearchQuery.withSeriesId(this.seriesId);
        }
        if (this.writeOnly) {
            eventSearchQuery.withAction(Permissions.Action.WRITE);
        }
        try {
            SearchResult result = searchIndex.getByQuery(eventSearchQuery);
            Arrays.stream(result.getItems()).forEach(item -> ((Event)item.getSource()).updatePreview(opencastContext.getConfiguration().eventPreviewSubtype()));
            return new GqlEventList((SearchResult<Event>)result);
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(OpencastErrorType.InternalError, (Throwable)e);
        }
    }

    private EventSearchQuery addEventFilterByParams(EventSearchQuery eventSearchQuery, DataFetchingEnvironment environment) {
        EventFilterByInput eventFilterBy = this.parseObjectParam("filterBy", EventFilterByInput.class, environment);
        if (eventFilterBy == null) {
            return eventSearchQuery;
        }
        if (eventFilterBy.getStatus() != null) {
            eventSearchQuery.withEventStatus(eventFilterBy.getStatus().getFilterValue());
        }
        if (eventFilterBy.getSeriesId() != null) {
            eventSearchQuery.withSeriesId(eventFilterBy.getSeriesId());
        }
        if (eventFilterBy.getPublished() != null) {
            eventSearchQuery.withIsPublished(eventFilterBy.getPublished().booleanValue());
        }
        return eventSearchQuery;
    }

    public EventSearchQuery addEventOrderByParams(EventSearchQuery eventSearchQuery, DataFetchingEnvironment environment) {
        EventOrderByInput eventOrderBy = this.parseObjectParam("orderBy", EventOrderByInput.class, environment);
        if (eventOrderBy == null) {
            return eventSearchQuery;
        }
        if (eventOrderBy.getTitle() != null) {
            eventSearchQuery.sortByTitle(eventOrderBy.getTitle().getOrder());
        }
        if (eventOrderBy.getPresenters() != null) {
            eventSearchQuery.sortByPresenter(eventOrderBy.getPresenters().getOrder());
        }
        if (eventOrderBy.getSeriesName() != null) {
            eventSearchQuery.sortBySeriesName(eventOrderBy.getSeriesName().getOrder());
        }
        if (eventOrderBy.getTechnicalStartTime() != null) {
            eventSearchQuery.sortByTechnicalStartDate(eventOrderBy.getTechnicalStartTime().getOrder());
        }
        if (eventOrderBy.getTechnicalEndTime() != null) {
            eventSearchQuery.sortByTechnicalEndDate(eventOrderBy.getTechnicalEndTime().getOrder());
        }
        if (eventOrderBy.getStartDate() != null) {
            eventSearchQuery.sortByStartDate(eventOrderBy.getStartDate().getOrder());
        }
        if (eventOrderBy.getEndDate() != null) {
            eventSearchQuery.sortByEndDate(eventOrderBy.getEndDate().getOrder());
        }
        if (eventOrderBy.getCreated() != null) {
            eventSearchQuery.withSortOrder("created", eventOrderBy.getCreated().getOrder());
        }
        if (eventOrderBy.getWorkflowState() != null) {
            eventSearchQuery.sortByWorkflowState(eventOrderBy.getWorkflowState().getOrder());
        }
        if (eventOrderBy.getLocation() != null) {
            eventSearchQuery.sortByLocation(eventOrderBy.getLocation().getOrder());
        }
        if (eventOrderBy.getEventStatus() != null) {
            eventSearchQuery.sortByEventStatus(eventOrderBy.getEventStatus().getOrder());
        }
        return eventSearchQuery;
    }
}

