/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.event;

import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.graphql.config.GraphQLConfiguration;
import org.opencastproject.graphql.datafetcher.ContextDataFetcher;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.OpencastErrorType;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.security.api.SecurityService;

public class EventDataFetcher
implements ContextDataFetcher<GqlEvent> {
    private final String eventId;

    public EventDataFetcher(String eventId) {
        Objects.requireNonNull(eventId, "Event identifier must not be null.");
        this.eventId = eventId;
    }

    @Override
    public GqlEvent get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        SecurityService securityService = opencastContext.getService(SecurityService.class);
        ElasticsearchIndex searchIndex = opencastContext.getService(ElasticsearchIndex.class);
        GraphQLConfiguration config = opencastContext.getConfiguration();
        try {
            SearchResult result = searchIndex.getByQuery(new EventSearchQuery(securityService.getOrganization().getId(), securityService.getUser()).withIdentifier(this.eventId));
            if (result.getDocumentCount() == 0L) {
                return null;
            }
            if (result.getDocumentCount() == 1L) {
                Event event = (Event)result.getItems()[0].getSource();
                event.updatePreview(config.eventPreviewSubtype());
                return new GqlEvent((Event)result.getItems()[0].getSource());
            }
            throw new GraphQLRuntimeException("Multiple events found with the same identifier", OpencastErrorType.InternalError);
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(OpencastErrorType.InternalError, (Throwable)e);
        }
    }
}

