/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.event;

import com.entwinemedia.fn.data.Opt;
import graphql.schema.DataFetchingEnvironment;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.datafetcher.ContextDataFetcher;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.OpencastErrorType;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.type.output.GqlMetadataFieldInterface;
import org.opencastproject.graphql.util.MetadataFieldToGraphQLFieldMapper;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.impl.util.EventUtils;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;

public class CommonEventMetadataV2DataFetcher
implements ContextDataFetcher<Map<String, GqlMetadataFieldInterface>> {
    @Override
    public Map<String, GqlMetadataFieldInterface> get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        String eventId = ((GqlEvent)dataFetchingEnvironment.getSource()).id();
        ElasticsearchIndex searchIndex = opencastContext.getService(ElasticsearchIndex.class);
        IndexService indexService = opencastContext.getService(IndexService.class);
        try {
            Opt opt = indexService.getEvent(eventId, searchIndex);
            if (opt.isEmpty()) {
                throw new GraphQLNotFoundException(String.format("Could not resolve to a %s with the id of %s", "Event", eventId));
            }
            Event event = (Event)opt.get();
            EventCatalogUIAdapter eventCatalogUiAdapter = indexService.getCommonEventCatalogUIAdapter();
            HashMap<String, GqlMetadataFieldInterface> result = new HashMap<String, GqlMetadataFieldInterface>();
            DublinCoreMetadataCollection collection = EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)eventCatalogUiAdapter);
            collection.getOutputFields().forEach((key, value) -> result.put((String)key, MetadataFieldToGraphQLFieldMapper.mapType(value)));
            return result;
        }
        catch (ParseException | SearchIndexException e) {
            throw new GraphQLRuntimeException(OpencastErrorType.InternalError, e);
        }
    }
}

