/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher.event;

import com.entwinemedia.fn.data.Opt;
import graphql.schema.DataFetchingEnvironment;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.datafetcher.ContextDataFetcher;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.OpencastErrorType;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.impl.util.EventUtils;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.security.api.SecurityService;

public class CommonEventMetadataDataFetcher
implements ContextDataFetcher<Map<String, Object>> {
    @Override
    public Map<String, Object> get(OpencastContext opencastContext, DataFetchingEnvironment dataFetchingEnvironment) {
        String eventId = ((GqlEvent)dataFetchingEnvironment.getSource()).id();
        SecurityService securityService = opencastContext.getService(SecurityService.class);
        ElasticsearchIndex searchIndex = opencastContext.getService(ElasticsearchIndex.class);
        IndexService indexService = opencastContext.getService(IndexService.class);
        try {
            GqlEvent e = this.getEvent(searchIndex, eventId, securityService);
            Event event = this.getEventFromIndexService(indexService, eventId, searchIndex);
            EventCatalogUIAdapter eventCatalogUiAdapter = indexService.getCommonEventCatalogUIAdapter();
            DublinCoreMetadataCollection collection = EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)eventCatalogUiAdapter);
            return this.getOutputFields(collection);
        }
        catch (ParseException | SearchIndexException | IndexServiceException e) {
            throw new GraphQLRuntimeException(OpencastErrorType.InternalError, e);
        }
    }

    private GqlEvent getEvent(ElasticsearchIndex searchIndex, String eventId, SecurityService securityService) throws SearchIndexException {
        return searchIndex.getEvent(eventId, securityService.getOrganization().toString(), securityService.getUser()).map(GqlEvent::new).orElseThrow(() -> new GraphQLNotFoundException(String.format("Could not resolve to a %s with the id of %s", "Event", eventId)));
    }

    private Event getEventFromIndexService(IndexService indexService, String eventId, ElasticsearchIndex searchIndex) throws IndexServiceException, SearchIndexException {
        Opt opt = indexService.getEvent(eventId, searchIndex);
        if (opt.isEmpty()) {
            throw new GraphQLNotFoundException(String.format("Could not resolve to a %s with the id of %s", "Event", eventId));
        }
        return (Event)opt.get();
    }

    private Map<String, Object> getOutputFields(DublinCoreMetadataCollection collection) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        collection.getOutputFields().values().forEach(f -> {
            Object value = f.getValue();
            String outputID = f.getOutputID();
            MetadataField.Type type = f.getType();
            if (type.equals((Object)MetadataField.Type.DATE)) {
                Date date = (Date)value;
                if (date != null) {
                    SimpleDateFormat df = new SimpleDateFormat(f.getPattern());
                    df.setTimeZone(TimeZone.getTimeZone("UTC"));
                    result.put(outputID, df.format(date));
                }
            } else if (type.equals((Object)MetadataField.Type.DURATION)) {
                if (value instanceof String) {
                    result.put(outputID, Long.parseLong(((String)value).isEmpty() ? "0" : (String)value));
                } else if (value instanceof Long || value instanceof Integer) {
                    result.put(outputID, value);
                }
            } else {
                result.put(outputID, value);
            }
        });
        return result;
    }
}

