/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.datafetcher;

import graphql.schema.DataFetchingEnvironment;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.graphql.datafetcher.ParameterDataFetcher;
import org.opencastproject.graphql.type.input.SearchOrder;

public abstract class ElasticsearchDataFetcher<T>
extends ParameterDataFetcher<T> {
    public static final int DEFAULT_PAGE_SIZE = 20;

    protected <E extends SearchQuery> E addPaginationParams(E query, DataFetchingEnvironment environment) {
        query.withLimit(this.parseParam("limit", 20, environment).intValue()).withOffset(this.parseParam("offset", 0, environment).intValue());
        return query;
    }

    protected <E extends SearchQuery> E addOrderByParams(E query, DataFetchingEnvironment environment) {
        SearchOrder order = this.parseObjectParam("orderBy", SearchOrder.class, environment);
        if (order != null) {
            query.withSortOrder(order.getField(), order.getDirection().getOrder());
        }
        return query;
    }

    protected <E extends SearchQuery> E addQueryParams(E query, DataFetchingEnvironment environment) {
        if (environment.containsArgument("query")) {
            query.withText((String)this.parseParam("query", null, environment));
        }
        return query;
    }
}

