/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.command;

import java.util.Map;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.graphql.command.AbstractCommand;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.GraphQLUnauthorizedException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.input.AccessControlItemInput;
import org.opencastproject.graphql.type.input.AccessControlListInput;
import org.opencastproject.graphql.type.input.GqlCommonSeriesMetadataInput;
import org.opencastproject.graphql.util.GraphQLObjectMapper;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.catalog.adapter.series.CommonSeriesCatalogUIAdapter;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.NotFoundException;

public class UpdateSeriesCommand
extends AbstractCommand<GqlSeries> {
    private final String seriesId;

    public UpdateSeriesCommand(Builder builder) {
        super(builder);
        this.seriesId = builder.seriesId;
    }

    @Override
    public GqlSeries execute() {
        OpencastContext context = OpencastContextManager.getCurrentContext();
        ElasticsearchIndex index = context.getService(ElasticsearchIndex.class);
        IndexService indexService = context.getService(IndexService.class);
        Map seriesMetadata = (Map)this.environment.getArgument("metadata");
        try {
            indexService.updateAllSeriesMetadata(this.seriesId, this.createMetadataList(seriesMetadata, indexService), index);
        }
        catch (IndexServiceException e) {
            throw new GraphQLRuntimeException(e);
        }
        catch (UnauthorizedException e) {
            throw new GraphQLUnauthorizedException(e.getMessage());
        }
        catch (NotFoundException e) {
            throw new GraphQLNotFoundException(e.getMessage());
        }
        SeriesService seriesService = context.getService(SeriesService.class);
        AccessControlListInput aclInput = (AccessControlListInput)GraphQLObjectMapper.newInstance().convertValue(this.environment.getArgument("acl"), AccessControlListInput.class);
        if (aclInput != null) {
            try {
                AccessControlList acl = new AccessControlList();
                for (AccessControlItemInput entry : aclInput.getEntries()) {
                    for (String action : entry.getAction()) {
                        acl.getEntries().add(new AccessControlEntry(entry.getRole(), action, true));
                    }
                }
                if (aclInput.getManagedAclId() != null) {
                    AclService aclService = context.getService(AclServiceFactory.class).serviceFor(context.getService(SecurityService.class).getOrganization());
                    aclService.getAcl(aclInput.getManagedAclId().longValue()).ifPresent(value -> acl.merge(value.getAcl()));
                }
                seriesService.updateAccessControl(this.seriesId, acl);
            }
            catch (UnauthorizedException e) {
                throw new GraphQLUnauthorizedException(e.getMessage());
            }
            catch (NotFoundException e) {
                throw new GraphQLNotFoundException(e.getMessage());
            }
            catch (SeriesException e) {
                throw new GraphQLRuntimeException(e);
            }
        }
        try {
            return new GqlSeries((Series)index.getSeries(this.seriesId, context.getOrganization().getId(), context.getUser()).get());
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(e);
        }
    }

    private MetadataList createMetadataList(Map<String, Object> seriesMetadata, IndexService indexService) {
        CommonSeriesCatalogUIAdapter adapter = (CommonSeriesCatalogUIAdapter)indexService.getCommonSeriesCatalogUIAdapter();
        MetadataList list = new MetadataList();
        list.add((SeriesCatalogUIAdapter)adapter, adapter.getRawFields());
        MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)"dublincore/series");
        DublinCoreMetadataCollection collection = list.getMetadataByFlavor(flavor.toString());
        seriesMetadata.keySet().forEach(k -> {
            MetadataField target = (MetadataField)collection.getOutputFields().get(k);
            target.setValue(seriesMetadata.get(k));
        });
        return list;
    }

    public static Builder create(String seriesId, GqlCommonSeriesMetadataInput seriesMetadataInput) {
        return new Builder(seriesId, seriesMetadataInput);
    }

    public static class Builder
    extends AbstractCommand.Builder<GqlSeries> {
        private final String seriesId;
        private final GqlCommonSeriesMetadataInput seriesMetadataInput;

        public Builder(String seriesId, GqlCommonSeriesMetadataInput seriesMetadataInput) {
            this.seriesId = seriesId;
            this.seriesMetadataInput = seriesMetadataInput;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.seriesId == null || this.seriesId.isEmpty()) {
                throw new IllegalStateException("Series ID cannot be null or empty");
            }
            if (this.seriesMetadataInput == null) {
                throw new IllegalStateException("Series metadata cannot be null");
            }
        }

        public UpdateSeriesCommand build() {
            this.validate();
            return new UpdateSeriesCommand(this);
        }
    }
}

