/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.command;

import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.graphql.command.AbstractCommand;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.GraphQLUnauthorizedException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.input.AccessControlItemInput;
import org.opencastproject.graphql.type.input.AccessControlListInput;
import org.opencastproject.graphql.util.GraphQLObjectMapper;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.NotFoundException;

public class UpdateSeriesAclCommand
extends AbstractCommand<GqlSeries> {
    private final String seriesId;

    public UpdateSeriesAclCommand(Builder builder) {
        super(builder);
        this.seriesId = builder.seriesId;
    }

    @Override
    public GqlSeries execute() {
        OpencastContext context = OpencastContextManager.getCurrentContext();
        SeriesService seriesService = context.getService(SeriesService.class);
        AccessControlListInput aclInput = (AccessControlListInput)GraphQLObjectMapper.newInstance().convertValue(this.environment.getArgument("acl"), AccessControlListInput.class);
        if (aclInput != null) {
            try {
                AccessControlList acl = new AccessControlList();
                for (AccessControlItemInput entry : aclInput.getEntries()) {
                    for (String action : entry.getAction()) {
                        acl.getEntries().add(new AccessControlEntry(entry.getRole(), action, true));
                    }
                }
                if (aclInput.getManagedAclId() != null) {
                    AclService aclService = context.getService(AclServiceFactory.class).serviceFor(context.getService(SecurityService.class).getOrganization());
                    aclService.getAcl(aclInput.getManagedAclId().longValue()).ifPresent(value -> acl.merge(value.getAcl()));
                }
                seriesService.updateAccessControl(this.seriesId, acl);
            }
            catch (UnauthorizedException e) {
                throw new GraphQLUnauthorizedException(e.getMessage());
            }
            catch (NotFoundException e) {
                throw new GraphQLNotFoundException(e.getMessage());
            }
            catch (SeriesException e) {
                throw new GraphQLRuntimeException(e);
            }
        }
        try {
            ElasticsearchIndex index = context.getService(ElasticsearchIndex.class);
            return new GqlSeries((Series)index.getSeries(this.seriesId, context.getOrganization().getId(), context.getUser()).get());
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(e);
        }
    }

    public static Builder create(String eventId) {
        return new Builder(eventId);
    }

    public static class Builder
    extends AbstractCommand.Builder<GqlSeries> {
        private final String seriesId;

        public Builder(String seriesId) {
            this.seriesId = seriesId;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.seriesId == null || this.seriesId.isEmpty()) {
                throw new IllegalStateException("Series ID cannot be null or empty");
            }
        }

        public UpdateSeriesAclCommand build() {
            this.validate();
            return new UpdateSeriesAclCommand(this);
        }
    }
}

