/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.command;

import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.command.AbstractCommand;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.GraphQLUnauthorizedException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.type.input.AccessControlItemInput;
import org.opencastproject.graphql.type.input.AccessControlListInput;
import org.opencastproject.graphql.type.input.GqlCommonEventMetadataInput;
import org.opencastproject.graphql.util.GraphQLObjectMapper;
import org.opencastproject.graphql.util.MetadataFieldToGraphQLConverter;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.catalog.adapter.events.CommonEventCatalogUIAdapter;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;

public class UpdateEventCommand
extends AbstractCommand<GqlEvent> {
    private final String eventId;

    public UpdateEventCommand(Builder builder) {
        super(builder);
        this.eventId = builder.eventId;
    }

    @Override
    public GqlEvent execute() {
        OpencastContext context = OpencastContextManager.getCurrentContext();
        ElasticsearchIndex index = context.getService(ElasticsearchIndex.class);
        IndexService indexService = context.getService(IndexService.class);
        Map eventMetadata = (Map)this.environment.getArgument("metadata");
        try {
            indexService.updateEventMetadata(this.eventId, this.createMetadataList(eventMetadata, indexService), index);
        }
        catch (SearchIndexException | IndexServiceException e) {
            throw new GraphQLRuntimeException(e);
        }
        catch (UnauthorizedException e) {
            throw new GraphQLUnauthorizedException(e.getMessage());
        }
        catch (NotFoundException e) {
            throw new GraphQLNotFoundException(e.getMessage());
        }
        AccessControlListInput aclInput = (AccessControlListInput)GraphQLObjectMapper.newInstance().convertValue(this.environment.getArgument("acl"), AccessControlListInput.class);
        if (aclInput != null) {
            try {
                AccessControlList acl = new AccessControlList();
                for (AccessControlItemInput entry : aclInput.getEntries()) {
                    for (String action : entry.getAction()) {
                        acl.getEntries().add(new AccessControlEntry(entry.getRole(), action, true));
                    }
                }
                if (aclInput.getManagedAclId() != null) {
                    AclService aclService = context.getService(AclServiceFactory.class).serviceFor(context.getService(SecurityService.class).getOrganization());
                    aclService.getAcl(aclInput.getManagedAclId().longValue()).ifPresent(value -> acl.merge(value.getAcl()));
                }
                indexService.updateEventAcl(this.eventId, acl, index);
            }
            catch (SearchIndexException | IndexServiceException e) {
                throw new GraphQLRuntimeException(e);
            }
            catch (UnauthorizedException e) {
                throw new GraphQLUnauthorizedException(e.getMessage());
            }
            catch (NotFoundException e) {
                throw new GraphQLNotFoundException(e.getMessage());
            }
        }
        try {
            return new GqlEvent((Event)indexService.getEvent(this.eventId, index).get());
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(e);
        }
    }

    private MetadataList createMetadataList(Map<String, Object> eventMetadata, IndexService indexService) {
        CommonEventCatalogUIAdapter adapter = (CommonEventCatalogUIAdapter)indexService.getCommonEventCatalogUIAdapter();
        MetadataList list = new MetadataList();
        list.add((EventCatalogUIAdapter)adapter, adapter.getRawFields());
        MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)"dublincore/episode");
        DublinCoreMetadataCollection collection = list.getMetadataByFlavor(flavor.toString());
        block12: for (Map.Entry<String, Object> entry : eventMetadata.entrySet()) {
            String key = entry.getKey();
            MetadataField target = (MetadataField)collection.getOutputFields().get(key);
            GraphQLType type = GraphQLTypeUtil.unwrapNonNull((GraphQLType)MetadataFieldToGraphQLConverter.convertType(target));
            Object value = type instanceof GraphQLScalarType ? ((GraphQLScalarType)type).getCoercing().parseValue(eventMetadata.get(key), this.environment.getGraphQlContext(), this.environment.getLocale()) : eventMetadata.get(key);
            if (value == null) continue;
            switch (target.getType()) {
                case DATE: 
                case START_DATE: {
                    target.setValue((Object)DateTimeFormatter.ofPattern(target.getPattern()).format((OffsetDateTime)value));
                    continue block12;
                }
                case LONG: {
                    target.setValue(value);
                    continue block12;
                }
                case TEXT: {
                    target.setValue(value);
                    continue block12;
                }
                case BOOLEAN: {
                    target.setValue(value);
                    continue block12;
                }
                case DURATION: {
                    target.setValue((Object)((Duration)value).toMillis());
                    continue block12;
                }
                case TEXT_LONG: {
                    target.setValue(value);
                    continue block12;
                }
                case MIXED_TEXT: {
                    target.setValue(value);
                    continue block12;
                }
                case START_TIME: {
                    target.setValue(value);
                    continue block12;
                }
                case ORDERED_TEXT: {
                    target.setValue(value);
                    continue block12;
                }
                case ITERABLE_TEXT: {
                    target.setValue(value);
                    continue block12;
                }
            }
            target.setValue(value);
        }
        return list;
    }

    public static Builder create(String eventId, GqlCommonEventMetadataInput eventMetadataInput) {
        return new Builder(eventId, eventMetadataInput);
    }

    public static class Builder
    extends AbstractCommand.Builder<GqlEvent> {
        private final String eventId;
        private final GqlCommonEventMetadataInput eventMetadataInput;

        public Builder(String eventId, GqlCommonEventMetadataInput eventMetadataInput) {
            this.eventId = eventId;
            this.eventMetadataInput = eventMetadataInput;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.eventId == null || this.eventId.isEmpty()) {
                throw new IllegalStateException("Event ID cannot be null or empty");
            }
            if (this.eventMetadataInput == null) {
                throw new IllegalStateException("Event metadata cannot be null");
            }
        }

        public UpdateEventCommand build() {
            this.validate();
            return new UpdateEventCommand(this);
        }
    }
}

