/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.command;

import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.command.AbstractCommand;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.GraphQLUnauthorizedException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.type.input.AccessControlItemInput;
import org.opencastproject.graphql.type.input.AccessControlListInput;
import org.opencastproject.graphql.util.GraphQLObjectMapper;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;

public class UpdateEventAclCommand
extends AbstractCommand<GqlEvent> {
    private final String eventId;

    public UpdateEventAclCommand(Builder builder) {
        super(builder);
        this.eventId = builder.eventId;
    }

    @Override
    public GqlEvent execute() {
        OpencastContext context = OpencastContextManager.getCurrentContext();
        ElasticsearchIndex index = context.getService(ElasticsearchIndex.class);
        IndexService indexService = context.getService(IndexService.class);
        AccessControlListInput aclInput = (AccessControlListInput)GraphQLObjectMapper.newInstance().convertValue(this.environment.getArgument("acl"), AccessControlListInput.class);
        try {
            AccessControlList acl = new AccessControlList();
            for (AccessControlItemInput entry : aclInput.getEntries()) {
                for (String action : entry.getAction()) {
                    acl.getEntries().add(new AccessControlEntry(entry.getRole(), action, true));
                }
            }
            if (aclInput.getManagedAclId() != null) {
                AclService aclService = context.getService(AclServiceFactory.class).serviceFor(context.getService(SecurityService.class).getOrganization());
                aclService.getAcl(aclInput.getManagedAclId().longValue()).ifPresent(value -> acl.merge(value.getAcl()));
            }
            indexService.updateEventAcl(this.eventId, acl, index);
        }
        catch (SearchIndexException | IndexServiceException e) {
            throw new GraphQLRuntimeException(e);
        }
        catch (UnauthorizedException e) {
            throw new GraphQLUnauthorizedException(e.getMessage());
        }
        catch (NotFoundException e) {
            throw new GraphQLNotFoundException(e.getMessage());
        }
        try {
            return new GqlEvent((Event)indexService.getEvent(this.eventId, index).get());
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(e);
        }
    }

    public static Builder create(String eventId) {
        return new Builder(eventId);
    }

    public static class Builder
    extends AbstractCommand.Builder<GqlEvent> {
        private final String eventId;

        public Builder(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.eventId == null || this.eventId.isEmpty()) {
                throw new IllegalStateException("Event ID cannot be null or empty");
            }
        }

        public UpdateEventAclCommand build() {
            this.validate();
            return new UpdateEventAclCommand(this);
        }
    }
}

