/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.command;

import com.entwinemedia.fn.data.Opt;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.command.AbstractCommand;
import org.opencastproject.graphql.event.GqlDeleteEventPayload;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.exception.GraphQLUnauthorizedException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowDatabaseException;

public class DeleteEventCommand
extends AbstractCommand<GqlDeleteEventPayload> {
    private final String id;

    public DeleteEventCommand(Builder builder) {
        super(builder);
        this.id = builder.id;
    }

    @Override
    public GqlDeleteEventPayload execute() {
        IndexService.EventRemovalResult result;
        OpencastContext context = OpencastContextManager.getCurrentContext();
        IndexService indexService = context.getService(IndexService.class);
        ElasticsearchIndex index = context.getService(ElasticsearchIndex.class);
        try {
            Opt event = indexService.getEvent(this.id, index);
            if (!event.isSome()) {
                throw new GraphQLNotFoundException("Event with id " + this.id + " not found.");
            }
            result = indexService.removeEvent((Event)event.get(), context.getConfiguration().eventRetractWorkflowId());
        }
        catch (UnauthorizedException e) {
            throw new GraphQLUnauthorizedException(e.getMessage());
        }
        catch (NotFoundException e) {
            throw new GraphQLNotFoundException(e.getMessage());
        }
        catch (SearchIndexException | WorkflowDatabaseException e) {
            throw new GraphQLRuntimeException(e);
        }
        return new GqlDeleteEventPayload(this.id, result);
    }

    public static Builder create(String id) {
        return new Builder(id);
    }

    public static class Builder
    extends AbstractCommand.Builder<GqlDeleteEventPayload> {
        private final String id;

        public Builder(String id) {
            this.id = id;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.id == null) {
                throw new IllegalArgumentException("Id can not be null.");
            }
        }

        public DeleteEventCommand build() {
            this.validate();
            return new DeleteEventCommand(this);
        }
    }
}

