/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.command;

import com.entwinemedia.fn.data.Opt;
import java.util.Map;
import java.util.TreeMap;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.graphql.command.AbstractCommand;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.input.AccessControlItemInput;
import org.opencastproject.graphql.type.input.AccessControlListInput;
import org.opencastproject.graphql.type.input.GqlCommonSeriesMetadataInput;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.catalog.adapter.series.CommonSeriesCatalogUIAdapter;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.series.api.SeriesService;

public class CreateSeriesCommand
extends AbstractCommand<GqlSeries> {
    private AccessControlListInput aclInput;

    public CreateSeriesCommand(Builder builder) {
        super(builder);
        this.aclInput = builder.accessControlListInput;
    }

    @Override
    public GqlSeries execute() {
        String seriesId;
        OpencastContext context = OpencastContextManager.getCurrentContext();
        ElasticsearchIndex index = context.getService(ElasticsearchIndex.class);
        IndexService indexService = context.getService(IndexService.class);
        Map seriesMetadata = (Map)this.environment.getArgument("metadata");
        MetadataList metadataList = this.createMetadataList(seriesMetadata, indexService);
        TreeMap options = new TreeMap();
        Opt optThemeId = Opt.none();
        SeriesService seriesService = context.getService(SeriesService.class);
        AccessControlList acl = new AccessControlList();
        for (AccessControlItemInput entry : this.aclInput.getEntries()) {
            for (String action : entry.getAction()) {
                acl.getEntries().add(new AccessControlEntry(entry.getRole(), action, true));
            }
        }
        if (this.aclInput.getManagedAclId() != null) {
            AclService aclService = context.getService(AclServiceFactory.class).serviceFor(context.getService(SecurityService.class).getOrganization());
            aclService.getAcl(this.aclInput.getManagedAclId().longValue()).ifPresent(value -> acl.merge(value.getAcl()));
        }
        try {
            seriesId = indexService.createSeries(metadataList, options, Opt.some((Object)acl), optThemeId);
        }
        catch (IndexServiceException e) {
            throw new GraphQLRuntimeException(e);
        }
        try {
            return new GqlSeries((Series)index.getSeries(seriesId, context.getOrganization().getId(), context.getUser()).get());
        }
        catch (SearchIndexException e) {
            throw new GraphQLRuntimeException(e);
        }
    }

    private MetadataList createMetadataList(Map<String, Object> seriesMetadata, IndexService indexService) {
        CommonSeriesCatalogUIAdapter adapter = (CommonSeriesCatalogUIAdapter)indexService.getCommonSeriesCatalogUIAdapter();
        MetadataList list = new MetadataList();
        list.add((SeriesCatalogUIAdapter)adapter, adapter.getRawFields());
        MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)"dublincore/series");
        DublinCoreMetadataCollection collection = list.getMetadataByFlavor(flavor.toString());
        seriesMetadata.keySet().forEach(k -> {
            MetadataField target = (MetadataField)collection.getOutputFields().get(k);
            target.setValue(seriesMetadata.get(k));
        });
        return list;
    }

    public static Builder create(GqlCommonSeriesMetadataInput seriesMetadataInput, AccessControlListInput accessControlListInput) {
        return new Builder(seriesMetadataInput, accessControlListInput);
    }

    public static class Builder
    extends AbstractCommand.Builder<GqlSeries> {
        private final GqlCommonSeriesMetadataInput seriesMetadataInput;
        private final AccessControlListInput accessControlListInput;

        public Builder(GqlCommonSeriesMetadataInput seriesMetadataInput, AccessControlListInput accessControlListInput) {
            this.seriesMetadataInput = seriesMetadataInput;
            this.accessControlListInput = accessControlListInput;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.seriesMetadataInput == null) {
                throw new IllegalStateException("Series metadata cannot be null");
            }
            if (this.accessControlListInput == null) {
                throw new IllegalStateException("Access control list cannot be null");
            }
        }

        public CreateSeriesCommand build() {
            this.validate();
            return new CreateSeriesCommand(this);
        }
    }
}

