/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.acl;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.output.GqlAccessControlList;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLTypeExtension(value=GqlSeries.class)
public class AclSeriesExtension {
    private static final Logger logger = LoggerFactory.getLogger(AclSeriesExtension.class);
    private final GqlSeries series;

    public AclSeriesExtension(GqlSeries series) {
        this.series = series;
    }

    @GraphQLField
    @GraphQLNonNull
    public GqlAccessControlList acl() {
        return new GqlAccessControlList(AclSeriesExtension.getAclFromSeries(this.series.getSeries()));
    }

    protected static AccessControlList getAclFromSeries(Series series) {
        AccessControlList activeAcl = new AccessControlList();
        try {
            if (series.getAccessPolicy() != null) {
                activeAcl = AccessControlParser.parseAcl((String)series.getAccessPolicy());
            }
        }
        catch (Exception e) {
            logger.error("Unable to parse access policy", (Throwable)e);
        }
        return activeAcl;
    }
}

