/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.acl;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.graphql.event.GqlEvent;
import org.opencastproject.graphql.type.output.GqlAccessControlList;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLTypeExtension(value=GqlEvent.class)
public class AclEventExtension {
    private static final Logger logger = LoggerFactory.getLogger(AclEventExtension.class);
    private final GqlEvent event;

    public AclEventExtension(GqlEvent event) {
        this.event = event;
    }

    @GraphQLField
    @GraphQLNonNull
    public GqlAccessControlList acl() {
        return new GqlAccessControlList(AclEventExtension.getAclFromEvent(this.event.getEvent()));
    }

    protected static AccessControlList getAclFromEvent(Event event) {
        AccessControlList activeAcl = new AccessControlList();
        try {
            if (event.getAccessPolicy() != null) {
                activeAcl = AccessControlParser.parseAcl((String)event.getAccessPolicy());
            }
        }
        catch (Exception e) {
            logger.error("Unable to parse access policy", (Throwable)e);
        }
        return activeAcl;
    }
}

