/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql;

import graphql.annotations.processor.GraphQLAnnotations;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opencastproject.graphql.provider.GraphQLAdditionalTypeProvider;
import org.opencastproject.graphql.provider.GraphQLDynamicTypeProvider;
import org.opencastproject.graphql.provider.GraphQLExtensionProvider;
import org.opencastproject.graphql.provider.GraphQLTypeFunctionProvider;
import org.opencastproject.graphql.type.DateTimeFunction;
import org.opencastproject.graphql.type.DurationFunction;
import org.opencastproject.graphql.type.JsonFunction;
import org.opencastproject.graphql.type.MapFunction;
import org.opencastproject.graphql.type.TimeFunction;
import org.opencastproject.graphql.type.input.DublinCoreMetadataInput;
import org.opencastproject.graphql.type.input.GqlCommonEventMetadataInput;
import org.opencastproject.graphql.type.input.GqlCommonSeriesMetadataInput;
import org.opencastproject.graphql.type.output.GqlAccessControlGenericItem;
import org.opencastproject.graphql.type.output.GqlAccessControlGroupItem;
import org.opencastproject.graphql.type.output.GqlAccessControlUserItem;
import org.opencastproject.graphql.type.output.GqlCommonEventMetadata;
import org.opencastproject.graphql.type.output.GqlCommonEventMetadataV2;
import org.opencastproject.graphql.type.output.GqlCommonSeriesMetadata;
import org.opencastproject.graphql.type.output.GqlCommonSeriesMetadataV2;
import org.opencastproject.graphql.type.output.GqlDublinCoreMetadata;
import org.opencastproject.graphql.type.output.GqlMetadataFieldInterface;
import org.opencastproject.graphql.type.output.field.GqlDurationMetadataField;
import org.opencastproject.graphql.type.output.field.GqlIntMetadataField;
import org.opencastproject.graphql.type.output.field.GqlJsonMetadataField;
import org.opencastproject.graphql.type.output.field.GqlListMetadataField;
import org.opencastproject.graphql.type.output.field.GqlLongMetadataField;
import org.opencastproject.graphql.util.MetadataFieldToGraphQLConverter;
import org.opencastproject.graphql.util.MetadataFieldToGraphQLFieldMapper;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.catalog.adapter.ConfigurableDCCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.events.CommonEventCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.series.CommonSeriesCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;

@Component
@ServiceDescription(value="Opencast GraphQL Provider")
public class OpencastGraphQLProvider
implements GraphQLExtensionProvider,
GraphQLDynamicTypeProvider,
GraphQLAdditionalTypeProvider,
GraphQLTypeFunctionProvider {
    private final IndexService indexService;
    private final SecurityService securityService;

    @Activate
    public OpencastGraphQLProvider(@Reference IndexService indexService, @Reference SecurityService securityService) {
        this.indexService = indexService;
        this.securityService = securityService;
    }

    @Override
    public Set<Class<?>> getAdditionalOutputTypes() {
        return Set.of(GqlAccessControlUserItem.class, GqlAccessControlGroupItem.class, GqlAccessControlGenericItem.class, GqlJsonMetadataField.class, GqlLongMetadataField.class, GqlDurationMetadataField.class, GqlIntMetadataField.class, GqlListMetadataField.class);
    }

    @Override
    public Map<String, GraphQLOutputType> getDynamicOutputTypes(Organization organization, GraphQLAnnotations graphQLAnnotations) {
        HashMap<String, GraphQLOutputType> outputTypes = new HashMap<String, GraphQLOutputType>();
        Organization oldOrganization = this.securityService.getOrganization();
        this.securityService.setOrganization(organization);
        this.commonEpisodeMetadata(outputTypes, graphQLAnnotations);
        this.commonEpisodeMetadataV2(outputTypes, graphQLAnnotations);
        this.commonSeriesMetadata(outputTypes, graphQLAnnotations);
        this.commonSeriesMetadataV2(outputTypes, graphQLAnnotations);
        this.securityService.setOrganization(oldOrganization);
        return outputTypes;
    }

    @Override
    public Map<String, GraphQLInputType> getDynamicInputTypes(Organization organization, GraphQLAnnotations graphQLAnnotations) {
        HashMap<String, GraphQLInputType> inputTypes = new HashMap<String, GraphQLInputType>();
        Organization oldOrganization = this.securityService.getOrganization();
        this.securityService.setOrganization(organization);
        this.commonEpisodeMetadataInput(inputTypes, graphQLAnnotations);
        this.commonSeriesMetadataInput(inputTypes, graphQLAnnotations);
        this.securityService.setOrganization(oldOrganization);
        return inputTypes;
    }

    private void commonEpisodeMetadataInput(HashMap<String, GraphQLInputType> inputTypes, GraphQLAnnotations graphQLAnnotations) {
        CommonEventCatalogUIAdapter adapter = (CommonEventCatalogUIAdapter)this.indexService.getCommonEventCatalogUIAdapter();
        this.commonMetadataInput(inputTypes, graphQLAnnotations, (ConfigurableDCCatalogUIAdapter)adapter, "CommonEventMetadataInput", GqlCommonEventMetadataInput.class);
    }

    private void commonSeriesMetadataInput(HashMap<String, GraphQLInputType> inputTypes, GraphQLAnnotations graphQLAnnotations) {
        CommonSeriesCatalogUIAdapter adapter = (CommonSeriesCatalogUIAdapter)this.indexService.getCommonSeriesCatalogUIAdapter();
        this.commonMetadataInput(inputTypes, graphQLAnnotations, (ConfigurableDCCatalogUIAdapter)adapter, "CommonSeriesMetadataInput", GqlCommonSeriesMetadataInput.class);
    }

    private void commonMetadataInput(HashMap<String, GraphQLInputType> inputTypes, GraphQLAnnotations graphQLAnnotations, ConfigurableDCCatalogUIAdapter adapter, String graphQLTypeName, Class<? extends DublinCoreMetadataInput> clazz) {
        HashSet fieldDefinitions = new HashSet();
        adapter.getRawFields().getFields().stream().filter(f -> !f.isReadOnly()).forEach(f -> fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(f.getOutputID()).type((GraphQLInputType)MetadataFieldToGraphQLConverter.convertType(f)).description(f.getLabel()).build()));
        GraphQLInputObjectType type = (GraphQLInputObjectType)graphQLAnnotations.getObjectHandler().getTypeRetriever().getGraphQLType(clazz, graphQLAnnotations.getContainer(), true);
        GraphQLInputObjectType transformedObjectType = type.transform(builder -> fieldDefinitions.forEach(arg_0 -> ((GraphQLInputObjectType.Builder)builder).field(arg_0)));
        inputTypes.put(graphQLTypeName, (GraphQLInputType)transformedObjectType);
    }

    private void commonEpisodeMetadata(HashMap<String, GraphQLOutputType> outputTypes, GraphQLAnnotations graphQLAnnotations) {
        CommonEventCatalogUIAdapter adapter = (CommonEventCatalogUIAdapter)this.indexService.getCommonEventCatalogUIAdapter();
        this.commonMetadata(outputTypes, graphQLAnnotations, (ConfigurableDCCatalogUIAdapter)adapter, "CommonEventMetadata", GqlCommonEventMetadata.class);
    }

    private void commonEpisodeMetadataV2(HashMap<String, GraphQLOutputType> outputTypes, GraphQLAnnotations graphQLAnnotations) {
        CommonEventCatalogUIAdapter adapter = (CommonEventCatalogUIAdapter)this.indexService.getCommonEventCatalogUIAdapter();
        this.commonMetadataV2(outputTypes, graphQLAnnotations, (ConfigurableDCCatalogUIAdapter)adapter, "CommonEventMetadataV2", GqlCommonEventMetadataV2.class);
    }

    private void commonSeriesMetadata(HashMap<String, GraphQLOutputType> outputTypes, GraphQLAnnotations graphQLAnnotations) {
        CommonSeriesCatalogUIAdapter adapter = (CommonSeriesCatalogUIAdapter)this.indexService.getCommonSeriesCatalogUIAdapter();
        this.commonMetadata(outputTypes, graphQLAnnotations, (ConfigurableDCCatalogUIAdapter)adapter, "CommonSeriesMetadata", GqlCommonSeriesMetadata.class);
    }

    private void commonSeriesMetadataV2(HashMap<String, GraphQLOutputType> outputTypes, GraphQLAnnotations graphQLAnnotations) {
        CommonSeriesCatalogUIAdapter adapter = (CommonSeriesCatalogUIAdapter)this.indexService.getCommonSeriesCatalogUIAdapter();
        this.commonMetadataV2(outputTypes, graphQLAnnotations, (ConfigurableDCCatalogUIAdapter)adapter, "CommonSeriesMetadataV2", GqlCommonSeriesMetadataV2.class);
    }

    private void commonMetadata(HashMap<String, GraphQLOutputType> outputTypes, GraphQLAnnotations graphQLAnnotations, ConfigurableDCCatalogUIAdapter adapter, String graphQLTypeName, Class<? extends GqlDublinCoreMetadata> clazz) {
        HashSet<GraphQLFieldDefinition> fieldDefinitions = new HashSet<GraphQLFieldDefinition>();
        for (MetadataField m : adapter.getRawFields().getFields()) {
            GraphQLFieldDefinition.Builder builder2 = GraphQLFieldDefinition.newFieldDefinition();
            builder2.name(m.getOutputID());
            builder2.type((GraphQLOutputType)MetadataFieldToGraphQLConverter.convertType(m));
            builder2.description(m.getLabel());
            fieldDefinitions.add(builder2.build());
        }
        GraphQLObjectType type = (GraphQLObjectType)graphQLAnnotations.getObjectHandler().getTypeRetriever().getGraphQLType(clazz, graphQLAnnotations.getContainer(), false);
        GraphQLObjectType transformedObjectType = type.transform(builder -> fieldDefinitions.forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0)));
        outputTypes.put(graphQLTypeName, (GraphQLOutputType)transformedObjectType);
    }

    private void commonMetadataV2(HashMap<String, GraphQLOutputType> outputTypes, GraphQLAnnotations graphQLAnnotations, ConfigurableDCCatalogUIAdapter adapter, String graphQLTypeName, Class<? extends GqlDublinCoreMetadata> clazz) {
        HashSet<GraphQLFieldDefinition> fieldDefinitions = new HashSet<GraphQLFieldDefinition>();
        for (MetadataField m : adapter.getRawFields().getFields()) {
            GraphQLFieldDefinition.Builder builder2 = GraphQLFieldDefinition.newFieldDefinition();
            String outputId = m.getOutputID();
            builder2.name(outputId != null ? outputId : m.getInputID());
            Class<? extends GqlMetadataFieldInterface> outputType = MetadataFieldToGraphQLFieldMapper.mapToClass(m.getType());
            builder2.type((GraphQLOutputType)graphQLAnnotations.getObjectHandler().getTypeRetriever().getGraphQLType(outputType, graphQLAnnotations.getContainer(), false));
            builder2.description(m.getLabel());
            fieldDefinitions.add(builder2.build());
        }
        GraphQLObjectType type = (GraphQLObjectType)graphQLAnnotations.getObjectHandler().getTypeRetriever().getGraphQLType(clazz, graphQLAnnotations.getContainer(), false);
        GraphQLObjectType transformedObjectType = type.transform(builder -> fieldDefinitions.forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0)));
        outputTypes.put(graphQLTypeName, (GraphQLOutputType)transformedObjectType);
    }

    @Override
    public Set<TypeFunction> getTypeFunctions() {
        return Set.of(new DateTimeFunction(), new DurationFunction(), new JsonFunction(), new MapFunction(), new TimeFunction());
    }
}

