/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.fileupload.api.job;

import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opencastproject.fileupload.api.job.Chunk;
import org.opencastproject.fileupload.api.job.Payload;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;

@XmlType(name="uploadjob", namespace="http://fileupload.opencastproject.org")
@XmlRootElement(name="uploadjob", namespace="http://fileupload.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FileUploadJob {
    @XmlAttribute
    private String id;
    @XmlAttribute
    private JobState state = JobState.READY;
    private long modified;
    @XmlElement(name="payload")
    private Payload payload;
    @XmlElement(name="chunksize")
    private int chunksize = -1;
    @XmlElement(name="chunks-total")
    private long chunksTotal = 1L;
    @XmlElement(name="current-chunk")
    private Chunk currentChunk = new Chunk();

    public FileUploadJob() {
        this.id = UUID.randomUUID().toString();
        this.modified = System.currentTimeMillis();
        this.payload = new Payload("unknown", -1L, null, null);
    }

    public FileUploadJob(String filename, long filesize, int chunksize, MediaPackage mp, MediaPackageElementFlavor flavor) {
        this.id = UUID.randomUUID().toString();
        this.modified = System.currentTimeMillis();
        this.chunksize = chunksize;
        if (chunksize == -1) {
            this.chunksTotal = 1L;
        } else {
            this.chunksTotal = filesize / (long)chunksize;
            if (filesize % (long)chunksize != 0L) {
                ++this.chunksTotal;
            }
        }
        this.payload = new Payload(filename, filesize, mp, flavor);
    }

    public String getId() {
        return this.id;
    }

    public synchronized JobState getState() {
        return this.state;
    }

    public synchronized void setState(JobState state) {
        this.setLastModified(System.currentTimeMillis());
        this.state = state;
    }

    public void setLastModified(long time) {
        this.modified = time;
    }

    public long lastModified() {
        return this.modified;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public int getChunksize() {
        return this.chunksize;
    }

    public long getChunksTotal() {
        return this.chunksTotal;
    }

    public Chunk getCurrentChunk() {
        return this.currentChunk;
    }

    public void setCurrentChunk(Chunk currentChunk) {
        this.setLastModified(System.currentTimeMillis());
        this.currentChunk = currentChunk;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("FileUploadJob(id=").append(this.id).append(", filename=").append(this.payload.getFilename()).append(")");
        return sb.toString();
    }

    @XmlEnum
    public static enum JobState {
        READY,
        INPROGRESS,
        FINALIZING,
        COMPLETE;

    }
}

