/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.google.gson.Gson;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.opencastproject.external.common.ApiResponseBuilder;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ListProviderNotFoundException;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.list.query.StringListFilter;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/listproviders")
@Produces(value={"application/json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapilistproviders", title="External API List Providers Service", notes={}, abstractText="Provides resources and operations related to configurable lists")
@Component(immediate=true, service={ListProviderEndpoint.class}, property={"service.description=External API - List Providers Endpoint", "opencast.service.type=org.opencastproject.external.listproviders", "opencast.service.path=/api/listproviders"})
@JaxrsResource
public class ListProviderEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ListProviderEndpoint.class);
    private ListProvidersService listProvidersService;

    @Reference
    public void setListProvidersService(ListProvidersService listProvidersService) {
        this.listProvidersService = listProvidersService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - List Providers Endpoint");
    }

    @GET
    @Path(value="providers.json")
    @Produces(value={"application/json", "application/v1.10.0+json"})
    @RestQuery(name="availableProviders", description="Provides the list of the available list providers", responses={@RestResponse(description="Returns the availables list providers.", responseCode=200)}, returnDescription="")
    public Response getAvailableProviders(@HeaderParam(value="Accept") String acceptHeader) {
        JSONArray list = new JSONArray();
        list.add((Object)this.listProvidersService.getAvailableProviders());
        return ApiResponseBuilder.Json.ok(acceptHeader, list.toJSONString());
    }

    @GET
    @Path(value="{source}.json")
    @Produces(value={"application/json", "application/v1.10.0+json"})
    @RestQuery(name="list", description="Provides key-value list from the given source", pathParameters={@RestParameter(name="source", description="The source for the key-value list", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The maximum number of items to return per page", isRequired=false, name="limit", type=RestParameter.Type.INTEGER), @RestParameter(description="The offset", isRequired=false, name="offset", type=RestParameter.Type.INTEGER), @RestParameter(description="Filters", isRequired=false, name="filter", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the key-value list for the given source.", responseCode=200)}, returnDescription="")
    public Response getList(@PathParam(value="source") String source, @QueryParam(value="limit") int limit, @QueryParam(value="filter") String filter, @QueryParam(value="offset") int offset, @HeaderParam(value="Accept") String acceptHeader) {
        Map autocompleteList;
        ResourceListQueryImpl query = new ResourceListQueryImpl();
        query.setLimit(Integer.valueOf(limit));
        query.setOffset(Integer.valueOf(offset));
        this.addRequestFiltersToQuery(filter, query);
        try {
            autocompleteList = this.listProvidersService.getList(source, (ResourceListQuery)query, false);
        }
        catch (ListProviderNotFoundException e) {
            logger.debug("No list found for {}", (Object)source, (Object)e);
            return ApiResponseBuilder.notFound("", new Object[0]);
        }
        catch (ListProviderException e) {
            logger.error("Server error when getting list from provider {}", (Object)source, (Object)e);
            return ApiResponseBuilder.serverError("", new Object[0]);
        }
        Gson gson = new Gson();
        String jsonList = gson.toJson((Object)autocompleteList);
        return ApiResponseBuilder.Json.ok(acceptHeader, jsonList);
    }

    private void addRequestFiltersToQuery(String filterString, ResourceListQueryImpl query) {
        if (filterString != null) {
            String[] filters;
            for (String filter : filters = filterString.split(",")) {
                String[] splitFilter = filter.split(":", 2);
                if (splitFilter == null || splitFilter.length != 2) continue;
                String key = splitFilter[0].trim();
                String value = splitFilter[1].trim();
                query.addFilter((ResourceListFilter)new StringListFilter(key, value));
            }
        }
    }
}

