/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.util.statistics;

import org.apache.commons.lang3.StringUtils;
import org.opencastproject.statistics.api.ResourceType;

public final class ResourceTypeUtils {
    private static final String RESOURCE_TYPE_EPISODE = "episode";
    private static final String RESOURCE_TYPE_SERIES = "series";
    private static final String RESOURCE_TYPE_ORGANIZATION = "organization";
    private static final String RESOURCE_TYPE_UNKNOWN = "unknown";

    private ResourceTypeUtils() {
    }

    public static String toString(ResourceType resourceType) {
        String result;
        switch (resourceType) {
            case EPISODE: {
                result = RESOURCE_TYPE_EPISODE;
                break;
            }
            case SERIES: {
                result = RESOURCE_TYPE_SERIES;
                break;
            }
            case ORGANIZATION: {
                result = RESOURCE_TYPE_ORGANIZATION;
                break;
            }
            default: {
                result = RESOURCE_TYPE_UNKNOWN;
            }
        }
        return result;
    }

    public static ResourceType fromString(String resourceType) throws IllegalArgumentException {
        ResourceType result = null;
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            result = Enum.valueOf(ResourceType.class, resourceType.toUpperCase());
        }
        return result;
    }
}

