/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.Opt;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.external.common.ApiResponses;
import org.opencastproject.external.util.statistics.QueryUtils;
import org.opencastproject.external.util.statistics.ResourceTypeUtils;
import org.opencastproject.external.util.statistics.StatisticsProviderUtils;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsService;
import org.opencastproject.statistics.export.api.StatisticsExportService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.functions.Functions;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapistatistics", title="External API Statistics Endpoint", notes={}, abstractText="Provides statistics")
@Component(immediate=true, service={StatisticsEndpoint.class}, property={"service.description=External API - Statistics Endpoint", "opencast.service.type=org.opencastproject.external.statistics", "opencast.service.path=/api/statistics"})
public class StatisticsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsEndpoint.class);
    private SecurityService securityService;
    private IndexService indexService;
    private ElasticsearchIndex elasticsearchIndex;
    private StatisticsService statisticsService;
    private StatisticsExportService statisticsExportService;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    public void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
    }

    @Reference
    public void setStatisticsService(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    @Reference
    public void setStatisticsExportService(StatisticsExportService statisticsExportService) {
        this.statisticsExportService = statisticsExportService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Statistics Endpoint");
    }

    @GET
    @Path(value="providers")
    @RestQuery(name="getproviders", description="Returns a list of available statistics providers", returnDescription="The list of available statistics providers as JSON", restParameters={@RestParameter(name="filter", isRequired=false, description="Usage [Filter Name]:[Value to Filter With]. Available filter: \"resourceType\"", type=RestParameter.Type.STRING), @RestParameter(name="withparameters", isRequired=false, description="Whether the parameters should be included in the response.", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="Returns the requested statistics providers as JSON", responseCode=200), @RestResponse(description="If the current user is not authorized to perform this action", responseCode=401)})
    public Response getProviders(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="filter") String filter, @QueryParam(value="withparameters") Boolean withParameters) {
        ResourceType resourceType = null;
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            for (String f : filter.split(",")) {
                String[] filterTuple = f.split(":");
                if (filterTuple.length != 2) {
                    logger.debug("No value for filter {} in filters list: {}", (Object)filterTuple[0], (Object)filter);
                    continue;
                }
                String name = filterTuple[0];
                String value = f.substring(name.length() + 1);
                if ("resourceType".equals(name)) {
                    try {
                        resourceType = ResourceTypeUtils.fromString(value);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        return RestUtil.R.badRequest((String)"Invalid value for 'resourceType'");
                    }
                }
                logger.warn("Unknown filter criteria {}", (Object)name);
                return RestUtil.R.badRequest((String)"Unknown filter");
            }
        }
        Set providers = resourceType != null ? this.statisticsService.getProviders(resourceType) : this.statisticsService.getProviders();
        JSONArray result = new JSONArray();
        providers.stream().map(p -> StatisticsProviderUtils.toJson(p, withParameters)).forEach(arg_0 -> result.add(arg_0));
        return ApiResponses.Json.ok(acceptHeader, result.toJSONString());
    }

    @GET
    @Path(value="providers/{providerId}")
    @RestQuery(name="getprovider", description="Returns the statistics provider with the specified id", returnDescription="The requested statistics provider", pathParameters={@RestParameter(name="providerId", description="The identifier of the statistics provider", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="withparameters", isRequired=false, description="Whether the parameters should be included in the response.", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="Returns the requested statistics provider as JSON", responseCode=200)})
    public Response getProvider(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="providerId") String id, @QueryParam(value="withparameters") Boolean withParameters) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            Optional provider = this.statisticsService.getProvider(id);
            if (provider.isPresent()) {
                return ApiResponses.Json.ok(acceptHeader, StatisticsProviderUtils.toJson((StatisticsProvider)provider.get(), withParameters).toJSONString());
            }
            return ApiResponses.notFound("Cannot find a statistics provider with id '%s'.", id);
        }
        return RestUtil.R.badRequest((String)"Invalid value for providerId");
    }

    @POST
    @Path(value="data/query")
    @RestQuery(name="getstatistics", description="Returns the statistical data based on the query posted", returnDescription="The statistical data as JSON array", restParameters={@RestParameter(name="data", description="An JSON array describing the queries to be executed", isRequired=true, type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns the statistical data as requested by the query as JSON array", responseCode=200), @RestResponse(description="If the current user is not authorized to perform this action", responseCode=401)})
    public Response getStatistics(@HeaderParam(value="Accept") String acceptHeader, @FormParam(value="data") String data) {
        List<QueryUtils.Query> queries = null;
        try {
            queries = QueryUtils.parse(data, this.statisticsService);
        }
        catch (Exception e) {
            logger.debug("Unable to parse form parameter 'data' {}, exception: {}", (Object)data, (Object)e);
            return RestUtil.R.badRequest((String)("Unable to parse form parameter 'data': " + e.getMessage()));
        }
        JSONArray result = new JSONArray();
        queries.stream().peek(query -> this.checkAccess(query.getParameters().getResourceId(), query.getProvider().getResourceType())).map(query -> QueryUtils.execute(query)).forEach(arg_0 -> result.add(arg_0));
        return ApiResponses.Json.ok(acceptHeader, result.toJSONString());
    }

    @POST
    @Produces(value={"application/json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json"})
    @Path(value="data/export.csv")
    @RestQuery(name="getexportcsv", description="Returns a statistics csv export", returnDescription="The requested statistics csv export", restParameters={@RestParameter(name="data", description="A JSON object describing the query to be executed", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="limit", description="Limit for pagination.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="Offset for pagination.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="filter", description="Usage [Filter Name]:[Value to Filter With]. Multiple filters can be used by combining them with commas \",\".", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the csv data as requested by the query as plain text", responseCode=200), @RestResponse(description="If the current user is not authorized to perform this action", responseCode=401)})
    public Response getExportCSV(@HeaderParam(value="Accept") String acceptHeader, @FormParam(value="data") String data, @FormParam(value="limit") Integer limit, @FormParam(value="offset") Integer offset, @FormParam(value="filter") String filter) throws NotFoundException, SearchIndexException, UnauthorizedException {
        int lim = limit != null ? Math.max(0, limit) : 0;
        int off = offset != null ? Math.max(0, offset) : 0;
        Map<String, String> filters = Arrays.stream(Optional.ofNullable(filter).orElse("").split(",")).filter(f -> f.contains(":")).collect(Collectors.toMap(f -> f.substring(0, f.indexOf(":")), f -> f.substring(f.indexOf(":") + 1)));
        QueryUtils.Query query = null;
        try {
            query = QueryUtils.parseQuery(data, this.statisticsService);
        }
        catch (Exception e) {
            logger.debug("Unable to parse form parameter 'data' {}, exception: {}", (Object)data, (Object)e);
            return RestUtil.R.badRequest((String)("Unable to parse form parameter 'data': " + e.getMessage()));
        }
        this.checkAccess(query.getParameters().getResourceId(), query.getProvider().getResourceType());
        QueryUtils.ExportParameters parameters = (QueryUtils.ExportParameters)query.getParameters();
        String result = this.statisticsExportService.getCSV(query.getProvider(), parameters.getResourceId(), parameters.getFrom(), parameters.getTo(), parameters.getDataResolution(), this.elasticsearchIndex, ZoneId.systemDefault(), true, parameters.getDetailLevel(), lim, off, filters);
        return ApiResponses.Json.ok(acceptHeader, new JSONObject(Collections.singletonMap("csv", result)).toJSONString());
    }

    private void checkAccess(String resourceId, ResourceType resourceType) {
        try {
            switch (resourceType) {
                case EPISODE: {
                    this.checkMediapackageAccess(resourceId);
                    break;
                }
                case SERIES: {
                    this.checkSeriesAccess(resourceId);
                    break;
                }
                case ORGANIZATION: {
                    this.checkOrganizationAccess(resourceId);
                    break;
                }
            }
        }
        catch (SearchIndexException | UnauthorizedException e) {
            Functions.chuck((Throwable)e);
        }
    }

    private void checkMediapackageAccess(String mpId) throws UnauthorizedException, SearchIndexException {
        Opt event = this.indexService.getEvent(mpId, this.elasticsearchIndex);
        if (event.isNone()) {
            throw new UnauthorizedException(this.securityService.getUser(), "read");
        }
    }

    private void checkSeriesAccess(String seriesId) throws UnauthorizedException, SearchIndexException {
        Optional series = this.elasticsearchIndex.getSeries(seriesId, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (series.isEmpty()) {
            throw new UnauthorizedException(this.securityService.getUser(), "read");
        }
    }

    private void checkOrganizationAccess(String orgId) throws UnauthorizedException {
        boolean authorized;
        User currentUser = this.securityService.getUser();
        Organization currentOrg = this.securityService.getOrganization();
        String currentOrgAdminRole = currentOrg.getAdminRole();
        String currentOrgId = currentOrg.getId();
        boolean bl = authorized = currentUser.hasRole("ROLE_ADMIN") || currentUser.hasRole(currentOrgAdminRole) && currentOrgId.equals(orgId);
        if (!authorized) {
            throw new UnauthorizedException(currentUser, "read");
        }
    }
}

