/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.common;

public enum ApiVersion {
    VERSION_1_0_0(1, 0, 0),
    VERSION_1_1_0(1, 1, 0),
    VERSION_1_2_0(1, 2, 0),
    VERSION_1_3_0(1, 3, 0),
    VERSION_1_4_0(1, 4, 0),
    VERSION_1_5_0(1, 5, 0),
    VERSION_1_6_0(1, 6, 0),
    VERSION_1_7_0(1, 7, 0),
    VERSION_1_8_0(1, 8, 0),
    VERSION_1_9_0(1, 9, 0),
    VERSION_1_10_0(1, 10, 0),
    VERSION_1_11_0(1, 11, 0);

    public static final ApiVersion CURRENT_VERSION;
    private int major;
    private int minor;
    private int patch;
    private String versionString;

    private ApiVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.versionString = "v" + major + "." + minor + "." + patch;
    }

    public boolean isSmallerThan(ApiVersion other) {
        if (this.major < other.major) {
            return true;
        }
        if (this.major > other.major) {
            return false;
        }
        if (this.minor < other.minor) {
            return true;
        }
        if (this.minor > other.minor) {
            return false;
        }
        return this.patch < other.patch;
    }

    public String toExternalForm() {
        return this.versionString;
    }

    public String toString() {
        return this.toExternalForm();
    }

    static {
        CURRENT_VERSION = VERSION_1_11_0;
    }
}

