/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.common;

import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.SimpleSerializer;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.opencastproject.external.common.ApiMediaType;
import org.opencastproject.external.common.ApiVersion;

public final class ApiResponses {
    private static final String APPLICATION_PREFIX = "application/";

    private ApiResponses() {
    }

    public static Response notFound(String message, Object ... args) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format(message, args)).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    public static Response serverError(String message, Object ... args) {
        return Response.serverError().entity((Object)String.format(message, args)).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    public static class Json {
        private static final String JSON_SUFFIX = "+json";
        private static final SimpleSerializer serializer = new SimpleSerializer();

        public static Response ok(ApiVersion version, String body) {
            return Response.ok((Object)body, (String)(ApiResponses.APPLICATION_PREFIX + version.toExternalForm() + JSON_SUFFIX)).build();
        }

        public static Response ok(String acceptHeader, String body) {
            ApiVersion version = ApiMediaType.parse(acceptHeader).getVersion();
            return Json.ok(version, body);
        }

        public static Response ok(ApiVersion version, JValue json) {
            return Response.ok((Object)serializer.toJson(json), (String)(ApiResponses.APPLICATION_PREFIX + version.toExternalForm() + JSON_SUFFIX)).build();
        }

        public static Response ok(String acceptHeader, JValue json) {
            ApiVersion version = ApiMediaType.parse(acceptHeader).getVersion();
            return Json.ok(version, json);
        }

        public static Response created(String acceptHeader, URI location, JValue json) {
            ApiVersion version = ApiMediaType.parse(acceptHeader).getVersion();
            return Json.created(version, location, json);
        }

        public static Response created(ApiVersion version, URI location, JValue json) {
            return Response.created((URI)location).entity((Object)serializer.toJson(json)).type(ApiResponses.APPLICATION_PREFIX + version.toExternalForm() + JSON_SUFFIX).build();
        }

        public static Response conflict(ApiVersion version, JValue json) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)serializer.toJson(json)).type(ApiResponses.APPLICATION_PREFIX + version.toExternalForm() + JSON_SUFFIX).build();
        }
    }
}

