/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.execute.operation.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.execute.api.ExecuteException;
import org.opencastproject.execute.api.ExecuteService;
import org.opencastproject.inspection.api.MediaInspectionException;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowOperationResultImpl;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Execute Once Workflow Operation Handler", "workflow.operation=execute-once"})
public class ExecuteOnceWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteOnceWorkflowOperationHandler.class);
    public static final String EXEC_PROPERTY = "exec";
    public static final String PARAMS_PROPERTY = "params";
    public static final String LOAD_PROPERTY = "load";
    public static final String OUTPUT_FILENAME_PROPERTY = "output-filename";
    public static final String EXPECTED_TYPE_PROPERTY = "expected-type";
    public static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    public static final String TARGET_FLAVORS_PROPERTY = "target-flavors";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String TARGET_TAG_PROPERTY = "target-tag";
    public static final String SET_WF_PROPS_PROPERTY = "set-workflow-properties";
    protected ExecuteService executeService;
    private MediaInspectionService inspectionService = null;
    protected Workspace workspace;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        logger.debug("Running execute workflow operation with ID {}", (Object)operation.getId());
        String exec = StringUtils.trimToNull((String)operation.getConfiguration(EXEC_PROPERTY));
        String params = StringUtils.trimToNull((String)operation.getConfiguration(PARAMS_PROPERTY));
        float load = 1.0f;
        String loadPropertyStr = StringUtils.trimToEmpty((String)operation.getConfiguration(LOAD_PROPERTY));
        if (StringUtils.isNotBlank((CharSequence)loadPropertyStr)) {
            try {
                load = Float.parseFloat(loadPropertyStr);
            }
            catch (NumberFormatException e) {
                String description = StringUtils.trimToEmpty((String)operation.getDescription());
                logger.warn("Ignoring invalid load value '{}' on execute operation with description '{}'", (Object)loadPropertyStr, (Object)description);
            }
        }
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List targetFlavorStr = tagsAndFlavors.getTargetFlavors();
        List targetTags = tagsAndFlavors.getTargetTags();
        String outputFilename = StringUtils.trimToNull((String)operation.getConfiguration(OUTPUT_FILENAME_PROPERTY));
        String expectedTypeStr = StringUtils.trimToNull((String)operation.getConfiguration(EXPECTED_TYPE_PROPERTY));
        boolean setWfProps = Boolean.valueOf(StringUtils.trimToNull((String)operation.getConfiguration(SET_WF_PROPS_PROPERTY)));
        MediaPackageElementFlavor targetFlavor = null;
        if (!targetFlavorStr.isEmpty()) {
            targetFlavor = (MediaPackageElementFlavor)targetFlavorStr.get(0);
        }
        MediaPackageElement.Type expectedType = null;
        if (expectedTypeStr != null) {
            for (MediaPackageElement.Type type : MediaPackageElement.Type.values()) {
                if (!type.toString().equalsIgnoreCase(expectedTypeStr)) continue;
                expectedType = type;
                break;
            }
            if (expectedType == null) {
                throw new WorkflowOperationException("'" + expectedTypeStr + "' is not a valid element type");
            }
        }
        MediaPackageElement resultElement = null;
        try {
            Job job = this.executeService.execute(exec, params, mediaPackage, outputFilename, expectedType, load);
            WorkflowOperationResult result = null;
            if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
                throw new WorkflowOperationException("Execute operation failed");
            }
            if (StringUtils.isNotBlank((CharSequence)job.getPayload())) {
                if (setWfProps) {
                    resultElement = MediaPackageElementParser.getFromXml((String)job.getPayload());
                    Properties properties = new Properties();
                    File propertiesFile = this.workspace.get(resultElement.getURI());
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), StandardCharsets.UTF_8);){
                        properties.load(reader);
                    }
                    logger.debug("Loaded {} properties from {}", (Object)properties.size(), (Object)propertiesFile);
                    this.workspace.deleteFromCollection("executor", propertiesFile.getName());
                    HashMap<Object, Object> wfProps = new HashMap<Object, Object>(properties);
                    result = this.createResult(mediaPackage, wfProps, WorkflowOperationResult.Action.CONTINUE, job.getQueueTime());
                } else {
                    resultElement = MediaPackageElementParser.getFromXml((String)job.getPayload());
                    if (resultElement.getElementType() == MediaPackageElement.Type.Track) {
                        Job inspectionJob = null;
                        inspectionJob = this.inspectionService.inspect(resultElement.getURI());
                        if (!this.waitForStatus(new Job[]{inspectionJob}).isSuccess()) {
                            throw new ExecuteException("Media inspection of " + String.valueOf(resultElement.getURI()) + " failed");
                        }
                        resultElement = MediaPackageElementParser.getFromXml((String)inspectionJob.getPayload());
                    }
                    mediaPackage.add(resultElement);
                    URI uri = this.workspace.moveTo(resultElement.getURI(), mediaPackage.getIdentifier().toString(), resultElement.getIdentifier(), outputFilename);
                    resultElement.setURI(uri);
                    if (targetFlavor != null) {
                        resultElement.setFlavor(targetFlavor);
                    }
                    if (!targetTags.isEmpty()) {
                        for (String tag : targetTags) {
                            if (tag.startsWith("-")) {
                                resultElement.removeTag(tag.replaceAll("^-+", ""));
                                continue;
                            }
                            resultElement.addTag(tag);
                        }
                    }
                    result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, job.getQueueTime());
                }
            } else {
                result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, job.getQueueTime());
            }
            logger.debug("Execute operation {} completed", (Object)operation.getId());
            return result;
        }
        catch (ExecuteException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        catch (MediaPackageException e) {
            throw new WorkflowOperationException("Some result element couldn't be serialized", (Throwable)e);
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException("Could not find mediapackage", (Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowOperationException("Error unmarshalling a result mediapackage element", (Throwable)e);
        }
        catch (MediaInspectionException e) {
            throw new WorkflowOperationException("Media inspection of " + String.valueOf(resultElement.getURI()) + " failed", (Throwable)e);
        }
    }

    public WorkflowOperationResult skip(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        return new WorkflowOperationResultImpl(workflowInstance.getMediaPackage(), null, WorkflowOperationResult.Action.SKIP, 0L);
    }

    public String getId() {
        return "execute";
    }

    public String getDescription() {
        return "Executes command line workflow operations in workers";
    }

    public void destroy(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
    }

    @Reference
    public void setExecuteService(ExecuteService service) {
        this.executeService = service;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setMediaInspectionService(MediaInspectionService mediaInspectionService) {
        this.inspectionService = mediaInspectionService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

