/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.execute.impl.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.execute.api.ExecuteException;
import org.opencastproject.execute.api.ExecuteService;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/execute")
@RestService(name="execute", title="Execute Service", notes={""}, abstractText="Runs CLI commands with MediaPackageElement's as parameters")
@Component(immediate=true, service={ExecuteRestEndpoint.class}, property={"service.description=Execute REST Endpoint", "opencast.service.type=org.opencastproject.execute", "opencast.service.path=/execute", "opencast.service.jobproducer=true"})
@JaxrsResource
public class ExecuteRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteRestEndpoint.class);
    protected ServiceRegistry serviceRegistry = null;
    protected ExecuteService service;

    @POST
    @Produces(value={"text/xml"})
    @Path(value="execute")
    @RestQuery(name="name", description="Executes the given command", restParameters={@RestParameter(description="The command to execute", isRequired=true, name="exec", type=RestParameter.Type.STRING), @RestParameter(description="The arguments to the command", isRequired=true, name="params", type=RestParameter.Type.STRING), @RestParameter(description="The estimated load placed on the system by this command", isRequired=false, name="load", type=RestParameter.Type.FLOAT), @RestParameter(description="The mediapackage to apply the command to. Either this or inputElement are required", isRequired=false, name="inputMediaPackage", type=RestParameter.Type.TEXT), @RestParameter(description="The mediapackage element to apply the command to. Either this or inputMediaPackage are required", isRequired=false, name="inputElement", type=RestParameter.Type.TEXT), @RestParameter(description="The mediapackage element produced by the command", isRequired=false, name="outputFilename", type=RestParameter.Type.STRING), @RestParameter(description="The type of the returned element", isRequired=false, name="expectedType", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="XML-encoded Job is returned.", responseCode=204), @RestResponse(description="Service unavailabe or not currently present", responseCode=503), @RestResponse(description="Incorrect parameters", responseCode=400), @RestResponse(description="Problem executing the command or serializing the arguments/results", responseCode=500)}, returnDescription="")
    public Response execute(@FormParam(value="exec") String exec, @FormParam(value="params") String params, @FormParam(value="load") Float loadParam, @FormParam(value="inputElement") String inputElementStr, @FormParam(value="inputMediaPackage") String inputMpStr, @FormParam(value="outputFilename") String outputFileName, @FormParam(value="expectedType") String elementTypeStr) {
        this.checkNotNull(this.service);
        try {
            MediaPackageElement.Type expectedType = null;
            if (StringUtils.isNotBlank((CharSequence)elementTypeStr)) {
                for (MediaPackageElement.Type candidateType : MediaPackageElement.Type.values()) {
                    if (!candidateType.toString().equalsIgnoreCase(elementTypeStr)) continue;
                    expectedType = candidateType;
                    break;
                }
                if (expectedType == null) {
                    logger.error("Wrong element type specified: {}", (Object)elementTypeStr);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            float load = 1.0f;
            if (loadParam != null) {
                load = loadParam.floatValue();
            }
            Job retJob = null;
            if (StringUtils.isNotBlank((CharSequence)inputElementStr) && StringUtils.isNotBlank((CharSequence)inputMpStr)) {
                logger.error("Only one input MediaPackage OR input MediaPackageElement can be set at the same time");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isNotBlank((CharSequence)inputElementStr)) {
                MediaPackageElement inputElement = MediaPackageElementParser.getFromXml((String)inputElementStr);
                retJob = this.service.execute(exec, params, inputElement, outputFileName, expectedType, load);
            } else if (StringUtils.isNotBlank((CharSequence)inputMpStr)) {
                MediaPackage inputMp = MediaPackageParser.getFromXml((String)inputMpStr);
                retJob = this.service.execute(exec, params, inputMp, outputFileName, expectedType, load);
            } else {
                logger.error("A MediaPackage OR MediaPackageElement must be provided");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.ok((Object)new JaxbJob(retJob)).build();
        }
        catch (IllegalArgumentException e) {
            logger.error("The expected element type is required if an output filename is specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (MediaPackageException e) {
            logger.error("Received excepcion: {}", (Object)e.getMessage());
            return Response.serverError().build();
        }
        catch (ExecuteException e) {
            logger.error("Received error from the execute service: {}", (Object)e.getMessage());
            return Response.serverError().build();
        }
    }

    @Reference
    public void setExecuteService(ExecuteService service) {
        this.service = service;
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    protected void checkNotNull(Object ... services) {
        if (services != null) {
            for (Object object : services) {
                if (object != null) continue;
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

