/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.comment;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.User;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.Jsons;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.data.Option;

public final class EventCommentReply {
    private Option<Long> id;
    private String text;
    private Date creationDate;
    private Date modificationDate;
    private User author;

    public static EventCommentReply create(Option<Long> id, String text, User author) {
        Date creationDate = new Date();
        return EventCommentReply.create(id, text, author, creationDate, creationDate);
    }

    public static EventCommentReply create(Option<Long> id, String text, User author, Date creationDate, Date modificationDate) {
        return new EventCommentReply(id, text, author, creationDate, modificationDate);
    }

    private EventCommentReply(Option<Long> id, String text, User author, Date creationDate, Date modificationDate) {
        this.id = (Option)RequireUtil.notNull(id, (String)"id");
        this.text = RequireUtil.notEmpty((String)text, (String)"text");
        this.author = (User)RequireUtil.notNull((Object)author, (String)"author");
        this.creationDate = (Date)RequireUtil.notNull((Object)creationDate, (String)"creationDate");
        this.modificationDate = (Date)RequireUtil.notNull((Object)modificationDate, (String)"modificationDate");
    }

    public Option<Long> getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public User getAuthor() {
        return this.author;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCommentReply reply = (EventCommentReply)o;
        return this.text.equals(reply.getText()) && this.creationDate.equals(reply.getCreationDate()) && this.modificationDate.equals(reply.getModificationDate()) && this.author.equals((Object)reply.getAuthor());
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.text, this.creationDate, this.modificationDate, this.author});
    }

    public String toString() {
        return "Comment reply:" + String.valueOf(this.id) + "|" + StringUtils.abbreviate((String)this.text, (int)25);
    }

    public Jsons.Obj toJson() {
        Jsons.Obj authorObj = Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"name", (String)this.author.getName()), Jsons.p((String)"username", (String)this.author.getUsername()), Jsons.p((String)"email", (String)this.author.getEmail())});
        Jsons.Val idValue = Jsons.ZERO_VAL;
        if (this.id.isSome()) {
            idValue = Jsons.v((Number)((Number)this.id.get()));
        }
        return Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"id", (Jsons.Val)idValue), Jsons.p((String)"text", (String)this.text), Jsons.p((String)"author", (Jsons.Val)authorObj), Jsons.p((String)"creationDate", (String)DateTimeSupport.toUTC((long)this.creationDate.getTime())), Jsons.p((String)"modificationDate", (String)DateTimeSupport.toUTC((long)this.modificationDate.getTime()))});
    }
}

