/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.comment;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.event.comment.EventCommentException;
import org.opencastproject.event.comment.EventCommentReply;
import org.opencastproject.mediapackage.UnsupportedElementException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Misc;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class EventCommentParser {
    private static final String NAMESPACE = "http://comment.opencastproject.org";
    private static final XPath xpath = XPathFactory.newInstance().newXPath();

    private EventCommentParser() {
    }

    public static EventComment getCommentFromXml(String xml, UserDirectoryService userDirectoryService) throws EventCommentException {
        try {
            Document doc = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder().parse(IOUtils.toInputStream((String)xml, (String)"UTF-8"));
            return EventCommentParser.commentFromManifest(doc.getDocumentElement(), userDirectoryService);
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }

    private static EventComment commentFromManifest(Node commentNode, UserDirectoryService userDirectoryService) throws UnsupportedElementException {
        try {
            Long id = null;
            Double idAsDouble = ((Number)xpath.evaluate("@id", commentNode, XPathConstants.NUMBER)).doubleValue();
            if (!idAsDouble.isNaN()) {
                id = idAsDouble.longValue();
            }
            String eventId = (String)xpath.evaluate("@eventId", commentNode, XPathConstants.STRING);
            String organization = (String)xpath.evaluate("@organization", commentNode, XPathConstants.STRING);
            String text = (String)xpath.evaluate("text/text()", commentNode, XPathConstants.STRING);
            Node authorNode = (Node)xpath.evaluate("author", commentNode, XPathConstants.NODE);
            User author = EventCommentParser.userFromManifest(authorNode, userDirectoryService);
            Boolean resolved = BooleanUtils.toBoolean((Boolean)((Boolean)xpath.evaluate("@resolved", commentNode, XPathConstants.BOOLEAN)));
            String reason = (String)xpath.evaluate("reason/text()", commentNode, XPathConstants.STRING);
            if (StringUtils.isNotBlank((CharSequence)reason)) {
                reason = reason.trim();
            }
            String creationDateString = (String)xpath.evaluate("creationDate/text()", commentNode, XPathConstants.STRING);
            Date creationDate = new Date(DateTimeSupport.fromUTC((String)creationDateString));
            String modificationDateString = (String)xpath.evaluate("modificationDate/text()", commentNode, XPathConstants.STRING);
            Date modificationDate = new Date(DateTimeSupport.fromUTC((String)modificationDateString));
            EventComment comment = EventComment.create((Option<Long>)Option.option((Object)id), eventId, organization, text.trim(), author, reason, resolved, creationDate, modificationDate);
            NodeList replyNodes = (NodeList)xpath.evaluate("replies/reply", commentNode, XPathConstants.NODESET);
            for (int i = 0; i < replyNodes.getLength(); ++i) {
                comment.addReply(EventCommentParser.replyFromManifest(replyNodes.item(i), userDirectoryService));
            }
            return comment;
        }
        catch (XPathExpressionException e) {
            throw new UnsupportedElementException("Error while reading comment information from manifest", (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof UnsupportedElementException) {
                throw (UnsupportedElementException)e;
            }
            throw new UnsupportedElementException("Error while reading comment creation or modification date information from manifest", (Throwable)e);
        }
    }

    private static EventCommentReply replyFromManifest(Node commentReplyNode, UserDirectoryService userDirectoryService) throws UnsupportedElementException {
        try {
            Long id = null;
            Double idAsDouble = ((Number)xpath.evaluate("@id", commentReplyNode, XPathConstants.NUMBER)).doubleValue();
            if (!idAsDouble.isNaN()) {
                id = idAsDouble.longValue();
            }
            String text = (String)xpath.evaluate("text/text()", commentReplyNode, XPathConstants.STRING);
            Node authorNode = (Node)xpath.evaluate("author", commentReplyNode, XPathConstants.NODE);
            User author = EventCommentParser.userFromManifest(authorNode, userDirectoryService);
            String creationDateString = (String)xpath.evaluate("creationDate/text()", commentReplyNode, XPathConstants.STRING);
            Date creationDate = new Date(DateTimeSupport.fromUTC((String)creationDateString));
            String modificationDateString = (String)xpath.evaluate("modificationDate/text()", commentReplyNode, XPathConstants.STRING);
            Date modificationDate = new Date(DateTimeSupport.fromUTC((String)modificationDateString));
            return EventCommentReply.create((Option<Long>)Option.option((Object)id), text.trim(), author, creationDate, modificationDate);
        }
        catch (XPathExpressionException e) {
            throw new UnsupportedElementException("Error while reading comment reply information from manifest", (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof UnsupportedElementException) {
                throw (UnsupportedElementException)e;
            }
            throw new UnsupportedElementException("Error while reading comment reply creation or modification date information from manifest", (Throwable)e);
        }
    }

    private static User userFromManifest(Node authorNode, UserDirectoryService userDirectoryService) {
        try {
            String userName = (String)xpath.evaluate("username/text()", authorNode, XPathConstants.STRING);
            return userDirectoryService.loadUser(userName);
        }
        catch (XPathExpressionException e) {
            throw new UnsupportedElementException("Error while reading comment author information from manifest", (Throwable)e);
        }
    }

    public static String getAsXml(Collection<EventComment> comments) throws EventCommentException {
        Document doc = EventCommentParser.newDocument();
        Element commentsXml = doc.createElementNS(NAMESPACE, "comments");
        commentsXml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        doc.appendChild(commentsXml);
        for (EventComment c : comments) {
            commentsXml.appendChild(EventCommentParser.getAsXmlDocument(c, doc));
        }
        return EventCommentParser.serializeNode(commentsXml.getOwnerDocument());
    }

    public static String getAsXml(EventComment comment) throws EventCommentException {
        Document doc = EventCommentParser.newDocument();
        Element commentNode = EventCommentParser.getAsXmlDocument(comment, doc);
        return EventCommentParser.serializeNode(doc.appendChild(commentNode).getOwnerDocument());
    }

    public static String getAsXml(EventCommentReply reply) throws EventCommentException {
        Document xmlDocument = EventCommentParser.getAsXmlDocument(reply);
        return EventCommentParser.serializeNode(xmlDocument);
    }

    private static Element getAsXmlDocument(EventComment comment, Document doc) {
        Element commentXml = doc.createElementNS(NAMESPACE, "comment");
        commentXml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        if (comment.getId().isSome()) {
            commentXml.setAttribute("id", ((Long)comment.getId().get()).toString());
        }
        commentXml.setAttribute("eventId", comment.getEventId());
        commentXml.setAttribute("organization", comment.getOrganization());
        commentXml.setAttribute("resolved", Boolean.toString(comment.isResolvedStatus()));
        Element authorNode = EventCommentParser.getAuthorNode(comment.getAuthor(), doc);
        commentXml.appendChild(authorNode);
        Element creationDate = doc.createElement("creationDate");
        creationDate.setTextContent(DateTimeSupport.toUTC((long)comment.getCreationDate().getTime()));
        commentXml.appendChild(creationDate);
        Element modificationDate = doc.createElement("modificationDate");
        modificationDate.setTextContent(DateTimeSupport.toUTC((long)comment.getModificationDate().getTime()));
        commentXml.appendChild(modificationDate);
        Element text = doc.createElement("text");
        if (StringUtils.isNotBlank((CharSequence)comment.getText())) {
            text.appendChild(doc.createCDATASection(comment.getText()));
        }
        commentXml.appendChild(text);
        Element reason = doc.createElement("reason");
        if (StringUtils.isNotBlank((CharSequence)comment.getReason())) {
            reason.setTextContent(comment.getReason());
        }
        commentXml.appendChild(reason);
        Element repliesNode = doc.createElement("replies");
        for (EventCommentReply r : comment.getReplies()) {
            repliesNode.appendChild(EventCommentParser.getAsXml(r, doc));
        }
        commentXml.appendChild(repliesNode);
        return commentXml;
    }

    private static Document getAsXmlDocument(EventCommentReply reply) {
        Document doc = EventCommentParser.newDocument();
        Element replyNode = EventCommentParser.getAsXml(reply, doc);
        return doc.appendChild(replyNode).getOwnerDocument();
    }

    private static Element getAsXml(EventCommentReply reply, Document doc) {
        Element replyXml = doc.createElementNS(NAMESPACE, "reply");
        replyXml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        if (reply.getId().isSome()) {
            replyXml.setAttribute("id", ((Long)reply.getId().get()).toString());
        }
        Element authorNode = EventCommentParser.getAuthorNode(reply.getAuthor(), doc);
        replyXml.appendChild(authorNode);
        Element creationDate = doc.createElement("creationDate");
        creationDate.setTextContent(DateTimeSupport.toUTC((long)reply.getCreationDate().getTime()));
        replyXml.appendChild(creationDate);
        Element modificationDate = doc.createElement("modificationDate");
        modificationDate.setTextContent(DateTimeSupport.toUTC((long)reply.getModificationDate().getTime()));
        replyXml.appendChild(modificationDate);
        Element text = doc.createElement("text");
        if (StringUtils.isNotBlank((CharSequence)reply.getText())) {
            text.appendChild(doc.createCDATASection(reply.getText()));
        }
        replyXml.appendChild(text);
        return replyXml;
    }

    private static Element getAuthorNode(User author, Document doc) {
        Element authorNode = doc.createElement("author");
        Element username = doc.createElement("username");
        username.setTextContent(author.getUsername());
        authorNode.appendChild(username);
        Element email = doc.createElement("email");
        email.setTextContent(author.getEmail());
        authorNode.appendChild(email);
        Element name = doc.createElement("name");
        if (StringUtils.isNotBlank((CharSequence)author.getName())) {
            name.appendChild(doc.createCDATASection(author.getName()));
        }
        authorNode.appendChild(name);
        return authorNode;
    }

    private static String serializeNode(Document xmlDocument) throws EventCommentException {
        try {
            Transformer transformer = XmlSafeParser.newTransformerFactory().newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(xmlDocument), new StreamResult(writer));
            return writer.getBuffer().toString().trim();
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }

    private static Document newDocument() {
        DocumentBuilderFactory docBuilderFactory = XmlSafeParser.newDocumentBuilderFactory();
        docBuilderFactory.setNamespaceAware(true);
        try {
            return docBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            return (Document)Misc.chuck((Throwable)e);
        }
    }
}

