/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.comment.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.event.comment.EventCommentReply;
import org.opencastproject.event.comment.persistence.EventCommentReplyDto;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaUser;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.data.Option;

@Entity(name="EventComment")
@Table(name="oc_event_comment", indexes={@Index(name="IX_oc_event_comment_event", columnList="event, organization")})
@NamedQueries(value={@NamedQuery(name="EventComment.countAll", query="SELECT COUNT(e) FROM EventComment e"), @NamedQuery(name="EventComment.findAll", query="SELECT e FROM EventComment e"), @NamedQuery(name="EventComment.findReasons", query="SELECT e.reason FROM EventComment e WHERE e.organization = :org GROUP BY e.reason"), @NamedQuery(name="EventComment.findByEvent", query="SELECT e FROM EventComment e WHERE e.eventId = :eventId AND e.organization = :org ORDER BY e.creationDate"), @NamedQuery(name="EventComment.findByCommentId", query="SELECT e FROM EventComment e WHERE e.id = :commentId"), @NamedQuery(name="EventComment.findAllWIthOrg", query="SELECT e.organization, e.eventId FROM EventComment e ORDER BY e.organization ASC"), @NamedQuery(name="EventComment.clear", query="DELETE FROM EventComment e WHERE e.organization = :org")})
public class EventCommentDto {
    @Id
    @GeneratedValue
    @Column(name="id")
    private long id;
    @Column(name="organization", length=128, nullable=false)
    private String organization;
    @Column(name="event", length=128, nullable=false)
    private String eventId;
    @Lob
    @Column(name="text", nullable=false)
    private String text;
    @Column(name="creation_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="modification_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modificationDate;
    @Column(name="author", nullable=false)
    private String author;
    @Column(name="reason")
    private String reason;
    @Column(name="resolved_status", nullable=false)
    private boolean resolvedStatus = false;
    @OneToMany(targetEntity=EventCommentReplyDto.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="eventComment", orphanRemoval=true)
    private List<EventCommentReplyDto> replies = new ArrayList<EventCommentReplyDto>();

    public static EventCommentDto from(EventComment comment) {
        EventCommentDto dto = new EventCommentDto();
        if (comment.getId().isSome()) {
            dto.id = (Long)comment.getId().get();
        }
        dto.organization = comment.getOrganization();
        dto.eventId = comment.getEventId();
        dto.text = comment.getText();
        dto.creationDate = comment.getCreationDate();
        dto.modificationDate = comment.getModificationDate();
        dto.author = comment.getAuthor().getUsername();
        dto.reason = comment.getReason();
        dto.resolvedStatus = comment.isResolvedStatus();
        for (EventCommentReply reply : comment.getReplies()) {
            dto.addReply(EventCommentReplyDto.from(reply));
        }
        return dto;
    }

    public long getId() {
        return this.id;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public void setResolvedStatus(boolean resolvedStatus) {
        this.resolvedStatus = resolvedStatus;
    }

    public boolean isResolvedStatus() {
        return this.resolvedStatus;
    }

    public void setReplies(List<EventCommentReplyDto> replies) {
        this.replies = (List)RequireUtil.notNull(replies, (String)"replies");
    }

    public List<EventCommentReplyDto> getReplies() {
        return this.replies;
    }

    public boolean addReply(EventCommentReplyDto reply) {
        ((EventCommentReplyDto)RequireUtil.notNull((Object)reply, (String)"reply")).setEventComment(this);
        return this.replies.add(reply);
    }

    public boolean removeReply(EventCommentReplyDto reply) {
        return this.replies.remove(RequireUtil.notNull((Object)reply, (String)"reply"));
    }

    public EventComment toComment(UserDirectoryService userDirectoryService, OrganizationDirectoryService organizationDirectoryService) {
        User user = userDirectoryService.loadUser(this.author);
        if (user == null) {
            JpaOrganization org = null;
            try {
                org = (JpaOrganization)organizationDirectoryService.getOrganization(this.organization);
            }
            catch (Exception exception) {
                // empty catch block
            }
            user = new JpaUser(this.author, null, org, this.author, "ghost@localhost", "ghost", false);
        }
        EventComment comment = EventComment.create((Option<Long>)Option.option((Object)this.id), this.eventId, this.organization, this.text, user, this.reason, this.resolvedStatus, this.creationDate, this.modificationDate);
        for (EventCommentReplyDto reply : this.replies) {
            comment.addReply(reply.toCommentReply(userDirectoryService));
        }
        return comment;
    }
}

