/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.comment.persistence;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Comment;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.rebuild.AbstractIndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.event.comment.persistence.EventCommentDatabaseException;
import org.opencastproject.event.comment.persistence.EventCommentDatabaseService;
import org.opencastproject.event.comment.persistence.EventCommentDto;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventCommentDatabaseService.class, IndexProducer.class}, property={"service.description=Event Comment Database Service"})
public class EventCommentDatabaseServiceImpl
extends AbstractIndexProducer
implements EventCommentDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(EventCommentDatabaseServiceImpl.class);
    public static final String PERSISTENCE_UNIT = "org.opencastproject.event.comment";
    private EntityManagerFactory emf;
    private DBSessionFactory dbSessionFactory;
    private DBSession db;
    private OrganizationDirectoryService organizationDirectoryService;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private ComponentContext cc;
    private ElasticsearchIndex index;
    private static final Fn<EventComment, Boolean> filterOpenComments = new Fn<EventComment, Boolean>(){

        public Boolean apply(EventComment comment) {
            return !comment.isResolvedStatus();
        }
    };
    private static final Fn<EventComment, Boolean> filterNeedsCuttingComment = new Fn<EventComment, Boolean>(){

        public Boolean apply(EventComment comment) {
            return "EVENTS.EVENTS.DETAILS.COMMENTS.REASONS.CUTTING".equals(comment.getReason()) && !comment.isResolvedStatus();
        }
    };

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for event comments");
        this.cc = cc;
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Reference(target="(osgi.unit.name=org.opencastproject.event.comment)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.index = index;
    }

    @Override
    public List<String> getReasons() throws EventCommentDatabaseException {
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("EventComment.findReasons", String.class, new Object[]{Pair.of((Object)"org", (Object)this.securityService.getOrganization().getId())}));
        }
        catch (Exception e) {
            logger.error("Could not get reasons", (Throwable)e);
            throw new EventCommentDatabaseException(e);
        }
    }

    @Override
    public EventComment getComment(long commentId) throws NotFoundException, EventCommentDatabaseException {
        try {
            Optional event = (Optional)this.db.exec(this.getEventCommentQuery(commentId));
            if (event.isEmpty()) {
                throw new NotFoundException("Event comment with ID " + commentId + " does not exist");
            }
            return ((EventCommentDto)event.get()).toComment(this.userDirectoryService, this.organizationDirectoryService);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not get event comment {}", (Object)commentId, (Object)e);
            throw new EventCommentDatabaseException(e);
        }
    }

    @Override
    public void deleteComment(long commentId) throws NotFoundException, EventCommentDatabaseException {
        try {
            EventCommentDto event = (EventCommentDto)this.db.execTxChecked(em -> {
                Optional<EventCommentDto> eventOpt = this.getEventCommentQuery(commentId).apply((EntityManager)em);
                if (eventOpt.isEmpty()) {
                    throw new NotFoundException("Event comment with ID " + commentId + " does not exist");
                }
                em.remove((Object)eventOpt.get());
                return eventOpt.get();
            });
            this.updateIndices(event.getEventId());
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not delete event comment", (Throwable)e);
            throw new EventCommentDatabaseException(e);
        }
    }

    @Override
    public void deleteComments(String eventId) throws NotFoundException, EventCommentDatabaseException {
        int count = 0;
        try {
            count = (Integer)this.db.execTxChecked(em -> {
                List<EventComment> comments = this.getComments(eventId);
                for (EventComment comment : comments) {
                    long commentId = ((Long)comment.getId().get()).intValue();
                    Optional<EventCommentDto> event = this.getEventCommentQuery(commentId).apply((EntityManager)em);
                    if (event.isEmpty()) {
                        throw new NotFoundException("Event comment with ID " + commentId + " does not exist");
                    }
                    em.remove((Object)event.get());
                }
                return comments.size();
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not delete event comments", (Throwable)e);
            throw new EventCommentDatabaseException(e);
        }
        if (count > 0) {
            this.updateIndices(eventId);
        }
    }

    @Override
    public EventComment updateComment(EventComment comment) throws EventCommentDatabaseException {
        try {
            EventCommentDto commentDto = EventCommentDto.from(comment);
            EventComment updatedComment = ((EventCommentDto)this.db.execTx(Queries.namedQuery.persistOrUpdate((Object)commentDto))).toComment(this.userDirectoryService, this.organizationDirectoryService);
            this.updateIndices(updatedComment.getEventId());
            return updatedComment;
        }
        catch (Exception e) {
            throw new EventCommentDatabaseException(e);
        }
    }

    private Function<EntityManager, Optional<EventCommentDto>> getEventCommentQuery(long commentId) {
        return Queries.namedQuery.findOpt("EventComment.findByCommentId", EventCommentDto.class, new Object[]{Pair.of((Object)"commentId", (Object)commentId)});
    }

    @Override
    public List<EventComment> getComments(String eventId) throws EventCommentDatabaseException {
        try {
            return ((List)this.db.exec(Queries.namedQuery.findAll("EventComment.findByEvent", EventCommentDto.class, new Object[]{Pair.of((Object)"eventId", (Object)eventId), Pair.of((Object)"org", (Object)this.securityService.getOrganization().getId())}))).stream().map(c -> c.toComment(this.userDirectoryService, this.organizationDirectoryService)).sorted((c1, c2) -> {
                boolean v2;
                boolean v1 = c1.isResolvedStatus();
                return v1 ^ (v2 = c2.isResolvedStatus()) ? (v1 ^ false ? 1 : -1) : 0;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Could not retreive comments for event {}", (Object)eventId, (Object)e);
            throw new EventCommentDatabaseException(e);
        }
    }

    public Iterator<EventCommentDto> getComments() throws EventCommentDatabaseException {
        try {
            return ((List)this.db.exec(Queries.namedQuery.findAll("EventComment.findAll", EventCommentDto.class, new Object[0]))).iterator();
        }
        catch (Exception e) {
            logger.error("Could not retreive event comments", (Throwable)e);
            throw new EventCommentDatabaseException(e);
        }
    }

    public int countComments() throws EventCommentDatabaseException {
        try {
            return ((Number)this.db.exec(Queries.namedQuery.find("EventComment.countAll", Number.class, new Object[0]))).intValue();
        }
        catch (Exception e) {
            logger.error("Could not find the number of comments.", (Throwable)e);
            throw new EventCommentDatabaseException(e);
        }
    }

    public Map<String, List<String>> getEventsWithComments() {
        List orgIDsEventIDs = (List)this.db.exec(Queries.namedQuery.findAll("EventComment.findAllWIthOrg", Object[].class, new Object[0]));
        Hashtable<String, List<String>> orgEventsMap = new Hashtable<String, List<String>>();
        for (Object[] orgEventResult : orgIDsEventIDs) {
            String orgId = (String)orgEventResult[0];
            String eventId = (String)orgEventResult[1];
            if (!orgEventsMap.containsKey(orgId)) {
                ArrayList<String> eventIds = new ArrayList<String>();
                eventIds.add(eventId);
                orgEventsMap.put(orgId, eventIds);
                continue;
            }
            if (((List)orgEventsMap.get(orgId)).contains(eventId)) continue;
            ((List)orgEventsMap.get(orgId)).add(eventId);
        }
        return orgEventsMap;
    }

    private void updateIndices(String eventId) throws EventCommentDatabaseException {
        List<EventComment> comments = this.getComments(eventId);
        boolean hasOpenComments = !Stream.$(comments).filter(filterOpenComments).toList().isEmpty();
        boolean needsCutting = !Stream.$(comments).filter(filterNeedsCuttingComment).toList().isEmpty();
        String organization = this.securityService.getOrganization().getId();
        User user = this.securityService.getUser();
        this.updateIndex(eventId, !comments.isEmpty(), hasOpenComments, comments, needsCutting, organization, user);
    }

    private void updateIndex(String eventId, boolean hasComments, boolean hasOpenComments, List<EventComment> comments, boolean needsCutting, String organization, User user) {
        logger.debug("Updating comment status of event {} in the {} index.", (Object)eventId, (Object)this.index.getIndexName());
        if (!hasComments && hasOpenComments) {
            throw new IllegalStateException("Invalid comment update request: You can't have open comments without having any comments!");
        }
        if (!hasOpenComments && needsCutting) {
            throw new IllegalStateException("Invalid comment update request: You can't have an needs cutting comment without having any open comments!");
        }
        Function<Optional, Optional> updateFunction = eventOpt -> {
            if (eventOpt.isEmpty()) {
                logger.debug("Event {} not found for comment status updating", (Object)eventId);
                return Optional.empty();
            }
            Event event = (Event)eventOpt.get();
            event.setHasComments(hasComments);
            event.setHasOpenComments(hasOpenComments);
            ArrayList<Comment> indexComments = new ArrayList<Comment>();
            for (EventComment comment : comments) {
                indexComments.add(new Comment(((Long)comment.getId().get()).toString(), comment.getReason(), comment.getText(), comment.isResolvedStatus()));
            }
            event.setComments(indexComments);
            event.setNeedsCutting(needsCutting);
            return Optional.of(event);
        };
        try {
            this.index.addOrUpdateEvent(eventId, updateFunction, organization, user);
        }
        catch (SearchIndexException e) {
            logger.error("Error updating comment status of event {} in the {} index:", (Object)eventId, (Object)e);
        }
    }

    public void repopulate() throws IndexRebuildException {
        try {
            int total = this.countComments();
            this.logIndexRebuildBegin(logger, total, "events with comment");
            int[] current = new int[]{0};
            int n = 20;
            ArrayList updatedEventRange = new ArrayList();
            Map<String, List<String>> eventsWithComments = this.getEventsWithComments();
            for (String orgId : eventsWithComments.keySet()) {
                Organization organization = this.organizationDirectoryService.getOrganization(orgId);
                User systemUser = SecurityUtil.createSystemUser((ComponentContext)this.cc, (Organization)organization);
                SecurityUtil.runAs((SecurityService)this.securityService, (Organization)organization, (User)systemUser, () -> {
                    int i = 0;
                    for (String eventId : (List)eventsWithComments.get(orgId)) {
                        try {
                            current[0] = current[0] + this.getComments(eventId).size();
                            Optional<Event> updatedEventData = this.index.getEvent(eventId, orgId, this.securityService.getUser());
                            updatedEventData = this.getEventUpdateFunction(eventId).apply(updatedEventData);
                            updatedEventRange.add(updatedEventData.get());
                            if (updatedEventRange.size() < n && ++i < ((List)eventsWithComments.get(orgId)).size()) continue;
                            this.index.bulkEventUpdate((List)updatedEventRange);
                            this.logIndexRebuildProgress(logger, total, current[0], n);
                            updatedEventRange.clear();
                        }
                        catch (Throwable t) {
                            this.logSkippingElement(logger, "comment of event", eventId, organization, t);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.logIndexRebuildError(logger, e);
            throw new IndexRebuildException(this.getService(), (Throwable)e);
        }
    }

    public IndexRebuildService.Service getService() {
        return IndexRebuildService.Service.Comments;
    }

    private Function<Optional<Event>, Optional<Event>> getEventUpdateFunction(String eventId) {
        return eventOpt -> {
            try {
                if (eventOpt.isEmpty()) {
                    logger.debug("Event {} not found for comment status updating", (Object)eventId);
                    return Optional.empty();
                }
                List<EventComment> comments = this.getComments(eventId);
                Boolean hasComments = !comments.isEmpty();
                Boolean hasOpenComments = !Stream.$(comments).filter(filterOpenComments).toList().isEmpty();
                Boolean needsCutting = !Stream.$(comments).filter(filterNeedsCuttingComment).toList().isEmpty();
                logger.debug("Updating comment status of event {} in the {} index.", (Object)eventId, (Object)this.index.getIndexName());
                if (!hasComments.booleanValue() && hasOpenComments.booleanValue()) {
                    throw new IllegalStateException("Invalid comment update request: You can't have open comments without having any comments!");
                }
                if (!hasOpenComments.booleanValue() && needsCutting.booleanValue()) {
                    throw new IllegalStateException("Invalid comment update request: You can't have an needs cutting comment without having any open comments!");
                }
                Event event = (Event)eventOpt.get();
                event.setHasComments(hasComments.booleanValue());
                event.setHasOpenComments(hasOpenComments.booleanValue());
                ArrayList<Comment> indexComments = new ArrayList<Comment>();
                for (EventComment comment : comments) {
                    indexComments.add(new Comment(((Long)comment.getId().get()).toString(), comment.getReason(), comment.getText(), comment.isResolvedStatus()));
                }
                event.setComments(indexComments);
                event.setNeedsCutting(needsCutting.booleanValue());
                return Optional.of(event);
            }
            catch (EventCommentDatabaseException e) {
                logger.error("Unable to get comments from event {}", (Object)eventId, (Object)e);
                return Optional.empty();
            }
        };
    }
}

