/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.comment;

import java.util.List;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.event.comment.EventCommentException;
import org.opencastproject.event.comment.EventCommentService;
import org.opencastproject.event.comment.persistence.EventCommentDatabaseService;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={EventCommentService.class}, property={"service.description=Event Comment Service"})
public class EventCommentServiceImpl
implements EventCommentService {
    private EventCommentDatabaseService eventCommentDatabaseService;

    @Reference
    public void setEventCommentDatabaseService(EventCommentDatabaseService eventCommentDatabaseService) {
        this.eventCommentDatabaseService = eventCommentDatabaseService;
    }

    @Override
    public List<String> getReasons() throws EventCommentException {
        try {
            return this.eventCommentDatabaseService.getReasons();
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }

    @Override
    public EventComment getComment(long commentId) throws NotFoundException, EventCommentException {
        try {
            return this.eventCommentDatabaseService.getComment(commentId);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }

    @Override
    public void deleteComment(long commentId) throws NotFoundException, EventCommentException {
        try {
            this.eventCommentDatabaseService.deleteComment(commentId);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }

    @Override
    public void deleteComments(String eventId) throws NotFoundException, EventCommentException {
        try {
            this.eventCommentDatabaseService.deleteComments(eventId);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }

    @Override
    public EventComment updateComment(EventComment comment) throws EventCommentException {
        try {
            return this.eventCommentDatabaseService.updateComment(comment);
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }

    @Override
    public List<EventComment> getComments(String eventId) throws EventCommentException {
        try {
            return this.eventCommentDatabaseService.getComments(eventId);
        }
        catch (Exception e) {
            throw new EventCommentException(e);
        }
    }
}

