/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.email.template.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ArtifactInstaller.class, EmailTemplateScanner.class}, property={"service.description=Email Template Scanner"})
public class EmailTemplateScanner
implements ArtifactInstaller {
    private final Map<String, String> templates = new ConcurrentHashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(EmailTemplateScanner.class);

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    @Activate
    void activate(BundleContext ctx) {
        logger.info("EmailTemplateScanner activated");
    }

    public String getTemplate(String fileName) {
        return this.templates.get(fileName);
    }

    public boolean canHandle(File artifact) {
        return "email".equals(artifact.getParentFile().getName());
    }

    public void install(File artifact) throws Exception {
        try (FileInputStream is = new FileInputStream(artifact);){
            String template = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            this.templates.put(artifact.getName(), template);
            logger.info("Template {} installed", (Object)artifact.getName());
        }
    }

    public void uninstall(File artifact) throws Exception {
        Iterator<String> iter = this.templates.values().iterator();
        while (iter.hasNext()) {
            String temp = iter.next();
            if (!artifact.getName().equals(temp)) continue;
            logger.info("Uninstalling template {}", (Object)temp);
            iter.remove();
        }
    }

    public void update(File artifact) throws Exception {
        this.uninstall(artifact);
        this.install(artifact);
    }
}

