/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.email.template.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opencastproject.job.api.Incident;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.util.doc.DocData;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationInstance;

public class EmailData
extends DocData {
    private final WorkflowInstance workflow;
    private final Map<String, String> workflowConfig;
    private final MediaPackage mediaPackage;
    private final HashMap<String, HashMap<String, String>> catalogs;
    private final WorkflowOperationInstance failed;
    private final List<Incident> incidents;
    private final Map<String, String> orgProperties;

    public EmailData(String name, WorkflowInstance workflow, HashMap<String, HashMap<String, String>> catalogs, WorkflowOperationInstance failed, List<Incident> incidents, Map<String, String> orgProperties) {
        super(name, null, null);
        this.workflow = workflow;
        this.workflowConfig = new HashMap<String, String>();
        for (String key : workflow.getConfigurationKeys()) {
            this.workflowConfig.put(key, workflow.getConfiguration(key));
        }
        this.mediaPackage = workflow.getMediaPackage();
        this.catalogs = catalogs;
        this.failed = failed;
        this.incidents = incidents;
        this.orgProperties = orgProperties;
    }

    public String toString() {
        return "EmailDOC:name=" + (String)this.meta.get("name") + ", notes=" + String.valueOf(this.notes) + ", workflow id=" + this.workflow.getId() + ", media package id=" + String.valueOf(this.mediaPackage.getIdentifier());
    }

    public Map<String, Object> toMap() throws IllegalStateException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("meta", this.meta);
        m.put("notes", this.notes);
        m.put("mediaPackage", this.mediaPackage);
        m.put("workflow", this.workflow);
        m.put("workflowConfig", this.workflowConfig);
        m.put("catalogs", this.catalogs);
        m.put("failedOperation", this.failed);
        m.put("incident", this.incidents);
        m.put("organization", this.orgProperties);
        return m;
    }
}

