/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencastproject.elasticsearch.api.Language;
import org.opencastproject.elasticsearch.api.SearchMetadata;

public class SearchMetadataImpl<T>
implements SearchMetadata<T> {
    protected String name = null;
    protected List<T> values = new ArrayList<T>();
    protected Map<Language, List<T>> localizedValues = new HashMap<Language, List<T>>();
    protected boolean addToText = false;

    public SearchMetadataImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocalized() {
        return this.localizedValues != null && this.localizedValues.size() > 0;
    }

    public void addLocalizedValue(Language language, T v) {
        List<T> values;
        if (this.localizedValues == null) {
            this.localizedValues = new HashMap<Language, List<T>>();
        }
        if ((values = this.localizedValues.get(language)) == null) {
            values = new ArrayList<T>();
        }
        if (!values.contains(v)) {
            values.add(v);
        }
        this.localizedValues.put(language, values);
    }

    public Map<Language, List<T>> getLocalizedValues() {
        if (this.localizedValues == null) {
            return Collections.emptyMap();
        }
        return this.localizedValues;
    }

    public void addValue(T v) {
        if (this.values == null) {
            this.values = new ArrayList<T>();
        }
        if (!this.values.contains(v)) {
            this.values.add(v);
        }
    }

    public List<T> getValues() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        return this.values;
    }

    public T getValue() {
        if (this.values == null || this.values.size() == 0) {
            return null;
        }
        return this.values.get(0);
    }

    public void setAddToText(boolean addToText) {
        this.addToText = addToText;
    }

    public boolean addToText() {
        return this.addToText;
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
        if (this.localizedValues != null) {
            this.localizedValues.clear();
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SearchMetadata)) {
            return false;
        }
        return this.name.equals(((SearchMetadata)obj).getName());
    }

    public String toString() {
        return this.name;
    }
}

