/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencastproject.elasticsearch.api.Language;
import org.opencastproject.elasticsearch.api.SearchMetadata;
import org.opencastproject.elasticsearch.impl.SearchMetadataImpl;

public class SearchMetadataCollection
implements Collection<SearchMetadata<?>> {
    protected Map<String, SearchMetadata<?>> metadata = new HashMap();
    protected String identifier = null;
    protected String documentType = null;

    public SearchMetadataCollection(String documentType) {
        this(null, documentType);
    }

    public SearchMetadataCollection(String identifier, String documentType) {
        this.identifier = identifier;
        this.documentType = documentType;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void addField(String fieldName, Object fieldValue, boolean addToText) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Field name may not contain '.'");
        }
        if (fieldValue == null) {
            return;
        }
        SearchMetadata<?> m = this.metadata.get(fieldName);
        if (m == null) {
            m = new SearchMetadataImpl(fieldName);
            this.metadata.put(fieldName, m);
        }
        m.setAddToText(addToText);
        if (fieldValue.getClass().isArray()) {
            Object[] fieldValues;
            for (Object v : fieldValues = (Object[])fieldValue) {
                m.addValue(v);
            }
        } else {
            m.addValue(fieldValue);
        }
    }

    protected String getLocalizedFieldName(String fieldName, Language language) {
        return MessageFormat.format(fieldName, language.getIdentifier());
    }

    public List<SearchMetadata<?>> getMetadata() {
        return new ArrayList(this.metadata.values());
    }

    @Override
    public boolean add(SearchMetadata<?> e) {
        return this.metadata.put(e.getName(), e) != null;
    }

    @Override
    public boolean addAll(Collection<? extends SearchMetadata<?>> c) {
        for (SearchMetadata<?> m : c) {
            this.metadata.put(m.getName(), m);
        }
        return true;
    }

    @Override
    public void clear() {
        this.metadata.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.metadata.values().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.metadata.values().contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.metadata.isEmpty();
    }

    @Override
    public Iterator<SearchMetadata<?>> iterator() {
        ArrayList result = new ArrayList();
        result.addAll(this.metadata.values());
        return result.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.metadata.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.metadata.remove(o) != null;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean removed = false;
        for (SearchMetadata<?> m : this.metadata.values()) {
            if (c.contains(m)) continue;
            this.metadata.remove(m);
            removed = true;
        }
        return removed;
    }

    @Override
    public int size() {
        return this.metadata.size();
    }

    @Override
    public Object[] toArray() {
        return this.metadata.values().toArray();
    }

    public Map<String, SearchMetadata<?>> toMap() {
        return this.metadata;
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.metadata.values().toArray(new SearchMetadataImpl[this.metadata.size()]);
    }
}

