/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchTerms;
import org.opencastproject.elasticsearch.impl.SearchTermsImpl;
import org.opencastproject.util.requests.SortCriterion;

public abstract class AbstractSearchQuery
implements SearchQuery {
    protected List<String> types = new ArrayList<String>();
    protected List<String> fields = null;
    protected boolean fuzzySearch = true;
    protected List<SearchTerms<String>> text = null;
    protected String filter = null;
    protected int offset = -1;
    protected int limit = -1;
    private final Map<String, SortCriterion.Order> sortOrders = new LinkedHashMap<String, SortCriterion.Order>();

    protected AbstractSearchQuery() {
    }

    public AbstractSearchQuery(String documentType) {
        this();
        if (StringUtils.isNotBlank((CharSequence)documentType)) {
            this.types.add(documentType);
        }
    }

    public SearchQuery withTypes(String ... types) {
        this.types.addAll(Arrays.asList(types));
        return this;
    }

    public String[] getTypes() {
        return this.types.toArray(new String[0]);
    }

    public AbstractSearchQuery withField(String field) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(field);
        return this;
    }

    public AbstractSearchQuery withFields(String ... fields) {
        for (String field : fields) {
            this.withField(field);
        }
        return this;
    }

    public String[] getFields() {
        if (this.fields == null) {
            return new String[0];
        }
        return this.fields.toArray(new String[0]);
    }

    public SearchQuery withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public SearchQuery withOffset(int offset) {
        this.offset = Math.max(0, offset);
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public SearchQuery withText(String text) {
        return this.withText(true, SearchTerms.Quantifier.Any, text);
    }

    public SearchQuery withText(boolean fuzzy, String text) {
        return this.withText(fuzzy, SearchTerms.Quantifier.Any, text);
    }

    public SearchQuery withText(boolean fuzzy, SearchTerms.Quantifier quantifier, String ... text) {
        if (quantifier == null) {
            throw new IllegalArgumentException("Quantifier must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text must not be null");
        }
        if (this.text == null) {
            this.text = new ArrayList<SearchTerms<String>>();
        }
        this.fuzzySearch = fuzzy;
        if (text.length == 1 || SearchTerms.Quantifier.Any.equals((Object)quantifier)) {
            SearchTermsImpl<String> terms = null;
            for (SearchTerms<String> t : this.text) {
                if (!SearchTerms.Quantifier.Any.equals((Object)t.getQuantifier())) continue;
                terms = t;
                break;
            }
            if (terms == null) {
                terms = new SearchTermsImpl<String>(SearchTerms.Quantifier.Any, text);
                this.text.add(terms);
            }
        } else {
            this.text.add(new SearchTermsImpl<String>(quantifier, text));
        }
        return this;
    }

    public Collection<SearchTerms<String>> getTerms() {
        if (this.text == null) {
            return Collections.emptyList();
        }
        return this.text;
    }

    public String getQueryString() {
        if (this.text == null) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        for (SearchTerms<String> s : this.text) {
            for (String t : s.getTerms()) {
                if (query.isEmpty()) {
                    query.append(" ");
                }
                query.append(t);
            }
        }
        return query.toString();
    }

    public boolean isFuzzySearch() {
        return this.fuzzySearch;
    }

    public SearchQuery withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public SearchQuery withSortOrder(String field, SortCriterion.Order order) {
        this.sortOrders.put(Objects.requireNonNull(this.sortOrderFieldName(field)), Objects.requireNonNull(order));
        return this;
    }

    public Map<String, SortCriterion.Order> getSortOrders() {
        return Collections.unmodifiableMap(this.sortOrders);
    }

    public SortCriterion.Order getSortOrder(String field) {
        String sortField = this.sortOrderFieldName(field);
        if (!this.sortOrders.containsKey(sortField)) {
            return SortCriterion.Order.None;
        }
        return this.sortOrders.get(sortField);
    }

    protected abstract String sortOrderFieldName(String var1);
}

