/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.opencastproject.elasticsearch.api.SearchIndex;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.impl.ElasticsearchDocument;
import org.opencastproject.elasticsearch.impl.SearchMetadataCollection;
import org.opencastproject.elasticsearch.impl.SearchMetadataImpl;
import org.opencastproject.elasticsearch.impl.SearchResultImpl;
import org.opencastproject.elasticsearch.impl.SearchResultItemImpl;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElasticsearchIndex
implements SearchIndex {
    private static final Logger logger = LoggerFactory.getLogger(AbstractElasticsearchIndex.class);
    private static final int ELASTICSEARCH_INDEX_MAX_RESULT_WINDOW = Integer.MAX_VALUE;
    private static final int ELASTICSEARCH_TERM_AGGREGATION_SIZE = 10000;
    public static final String ELASTICSEARCH_SERVER_HOSTNAME_KEY = "org.opencastproject.elasticsearch.server.hostname";
    public static final String ELASTICSEARCH_SERVER_SCHEME_KEY = "org.opencastproject.elasticsearch.server.scheme";
    public static final String ELASTICSEARCH_SERVER_PORT_KEY = "org.opencastproject.elasticsearch.server.port";
    public static final String ELASTICSEARCH_USERNAME_KEY = "org.opencastproject.elasticsearch.username";
    public static final String ELASTICSEARCH_PASSWORD_KEY = "org.opencastproject.elasticsearch.password";
    private static final int ELASTICSEARCH_SERVER_PORT_DEFAULT = 9200;
    private static final String ELASTICSEARCH_SERVER_HOSTNAME_DEFAULT = "localhost";
    private static final String ELASTICSEARCH_SERVER_SCHEME_DEFAULT = "http";
    private static final String ROOT_ID = "root";
    private String indexIdentifier = null;
    private static final String INDEX_IDENTIFIER_PROPERTY = "index.identifier";
    private static final String DEFAULT_INDEX_IDENTIFIER = "opencast";
    private String indexName = null;
    private static final String INDEX_NAME_PROPERTY = "index.name";
    private static final String DEFAULT_INDEX_NAME = "Elasticsearch";
    private RestHighLevelClient client = null;
    private int indexVersion = -1;
    protected String indexSettingsPath;
    private String externalServerHostname = "localhost";
    private String externalServerScheme = "http";
    private int externalServerPort = 9200;
    private String username;
    private String password;
    private int retryDelayOnStartup;
    private static final String RETRY_DELAY_ON_STARTUP = "retry.delay.on.startup";
    private static final int DEFAULT_RETRY_DELAY_ON_STARTUP = 10000;

    public abstract String[] getDocumentTypes();

    public void activate(Map<String, Object> properties, BundleContext bundleContext) throws ComponentException {
        this.indexIdentifier = (String)StringUtils.defaultIfBlank((CharSequence)((String)properties.get(INDEX_IDENTIFIER_PROPERTY)), (CharSequence)DEFAULT_INDEX_IDENTIFIER);
        logger.info("Index identifier set to {}.", (Object)this.indexIdentifier);
        this.indexSettingsPath = StringUtils.trimToNull((String)bundleContext.getProperty("karaf.etc"));
        if (this.indexSettingsPath == null) {
            throw new ComponentException("Could not determine Karaf configuration path");
        }
        this.externalServerHostname = (String)StringUtils.defaultIfBlank((CharSequence)bundleContext.getProperty(ELASTICSEARCH_SERVER_HOSTNAME_KEY), (CharSequence)ELASTICSEARCH_SERVER_HOSTNAME_DEFAULT);
        this.externalServerScheme = (String)StringUtils.defaultIfBlank((CharSequence)bundleContext.getProperty(ELASTICSEARCH_SERVER_SCHEME_KEY), (CharSequence)ELASTICSEARCH_SERVER_SCHEME_DEFAULT);
        this.externalServerPort = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)bundleContext.getProperty(ELASTICSEARCH_SERVER_PORT_KEY), (CharSequence)"9200"));
        this.username = StringUtils.trimToNull((String)bundleContext.getProperty(ELASTICSEARCH_USERNAME_KEY));
        this.password = StringUtils.trimToNull((String)bundleContext.getProperty(ELASTICSEARCH_PASSWORD_KEY));
    }

    public void modified(Map<String, Object> properties) {
        this.indexName = (String)StringUtils.defaultIfBlank((CharSequence)((String)properties.get(INDEX_NAME_PROPERTY)), (CharSequence)DEFAULT_INDEX_NAME);
        logger.info("Index name set to {}.", (Object)this.indexName);
        this.retryDelayOnStartup = NumberUtils.toInt((String)((String)properties.get(RETRY_DELAY_ON_STARTUP)), (int)10000);
        if (this.retryDelayOnStartup <= 0) {
            throw new IllegalArgumentException("retry.delay.on.startup was wrongly configured. Value has to be greater than 0.");
        }
        logger.info("Retry delay on startup set to {} ms.", (Object)this.retryDelayOnStartup);
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public void clear() throws IOException {
        try {
            DeleteIndexRequest request = new DeleteIndexRequest((String[])Arrays.stream(this.getDocumentTypes()).map(this::getSubIndexIdentifier).toArray(String[]::new));
            AcknowledgedResponse delete = this.client.indices().delete(request, RequestOptions.DEFAULT);
            if (!delete.isAcknowledged()) {
                logger.error("Index '{}' could not be deleted", (Object)this.getIndexName());
            }
            this.createIndex();
        }
        catch (ElasticsearchException exception) {
            if (exception.status() == RestStatus.NOT_FOUND) {
                logger.error("Cannot clear non-existing index '{}'", (Object)exception.getIndex().getName());
            }
        }
        catch (SearchIndexException e) {
            logger.error("Unable to re-create the index after a clear", (Throwable)e);
        }
    }

    protected IndexResponse update(int maxRetryAttempts, int retryWaitingPeriod, ElasticsearchDocument document) throws IOException, InterruptedException {
        IndexRequest indexRequest = (IndexRequest)new IndexRequest(this.getSubIndexIdentifier(document.getType())).id(document.getUID()).source((Map)document).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        IndexResponse indexResponse = null;
        int retryAttempts = 0;
        do {
            try {
                indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
            }
            catch (ElasticsearchStatusException e) {
                if (++retryAttempts <= maxRetryAttempts) {
                    logger.warn("Could not update documents in index {}, retrying in {} ms.", new Object[]{this.getIndexName(), retryWaitingPeriod, e});
                    if (retryWaitingPeriod <= 0) continue;
                    Thread.sleep(retryWaitingPeriod);
                    continue;
                }
                logger.error("Could not update documents in index {}, not retrying.", (Object)this.getIndexName(), (Object)e);
                throw e;
            }
        } while (indexResponse == null);
        return indexResponse;
    }

    protected BulkResponse bulkUpdate(int maxRetryAttempts, int retryWaitingPeriod, List<ElasticsearchDocument> documents) throws IOException, InterruptedException {
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (ElasticsearchDocument document : documents) {
            bulkRequest.add(new IndexRequest(this.getSubIndexIdentifier(document.getType())).id(document.getUID()).source((Map)document));
        }
        BulkResponse bulkResponse = null;
        int retryAttempts = 0;
        do {
            try {
                bulkResponse = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (ElasticsearchStatusException e) {
                if (++retryAttempts <= maxRetryAttempts) {
                    logger.warn("Could not update documents in index {} because of {}, retrying in {} ms.", new Object[]{this.getIndexName(), e.getMessage(), retryWaitingPeriod});
                    if (retryWaitingPeriod <= 0) continue;
                    Thread.sleep(retryWaitingPeriod);
                    continue;
                }
                logger.error("Could not update documents in index {}, not retrying.", (Object)this.getIndexName(), (Object)e);
                throw e;
            }
        } while (bulkResponse == null);
        return bulkResponse;
    }

    protected DeleteResponse delete(String type, String id, int maxRetryAttempts, int retryWaitingPeriod) throws IOException, InterruptedException {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(this.getSubIndexIdentifier(type), id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        DeleteResponse deleteResponse = null;
        int retryAttempts = 0;
        do {
            try {
                deleteResponse = this.getClient().delete(deleteRequest, RequestOptions.DEFAULT);
            }
            catch (ElasticsearchStatusException e) {
                if (++retryAttempts <= maxRetryAttempts) {
                    logger.warn("Could not remove documents from index {} because of {}, retrying in {} ms.", new Object[]{this.getIndexName(), e.getMessage(), retryWaitingPeriod});
                    if (retryWaitingPeriod <= 0) continue;
                    Thread.sleep(retryWaitingPeriod);
                    continue;
                }
                logger.error("Could not remove documents from index {}, not retrying.", (Object)this.getIndexName(), (Object)e);
                throw e;
            }
        } while (deleteResponse == null);
        return deleteResponse;
    }

    protected void init(int version) throws IOException, IllegalArgumentException, SearchIndexException {
        this.indexVersion = version;
        if (this.client == null) {
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.externalServerHostname, this.externalServerPort, this.externalServerScheme)});
            if (this.username != null && this.password != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                builder.setHttpClientConfigCallback(arg_0 -> AbstractElasticsearchIndex.lambda$init$1((CredentialsProvider)credentialsProvider, arg_0));
            }
            this.client = new RestHighLevelClient(builder);
        }
        this.waitUntilOpensearchIsAvailable();
        this.createIndex();
    }

    private void waitUntilOpensearchIsAvailable() {
        String openSearchUrl = this.getOpensearchURL();
        logger.info("Testing connection to OpenSearch at {}", (Object)openSearchUrl);
        while (!this.isOpensearchReachable()) {
            logger.warn("Could not reach OpenSearch at {}. Trying again after {} ms...", (Object)openSearchUrl, (Object)this.retryDelayOnStartup);
            try {
                Thread.sleep(this.retryDelayOnStartup);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Could not reach OpenSearch at " + openSearchUrl, e);
            }
        }
        logger.info("Connection to OpenSearch at {} tested successfully", (Object)openSearchUrl);
    }

    private boolean isOpensearchReachable() {
        try {
            ClusterHealthRequest request = new ClusterHealthRequest();
            request.waitForYellowStatus();
            ClusterHealthResponse resp = this.client.cluster().health(request, RequestOptions.DEFAULT);
            if (resp.getStatus().equals((Object)ClusterHealthStatus.GREEN)) {
                logger.debug("Connected to OpenSearch, cluster health is {}", (Object)resp.getStatus());
                return true;
            }
            if (resp.getStatus().equals((Object)ClusterHealthStatus.YELLOW)) {
                logger.warn("Connected to OpenSearch, cluster health is {}", (Object)resp.getStatus());
                return true;
            }
            logger.debug("Connected to OpenSearch, but cluster health is {}", (Object)resp.getStatus());
            return false;
        }
        catch (ConnectException | ConnectionClosedException connectException) {
            logger.debug("Unable to connect to OpenSearch", connectException);
            return false;
        }
        catch (IOException ioException) {
            if (ioException.getCause() instanceof SocketException) {
                logger.debug("Unable to connect to OpenSearch", (Throwable)ioException);
                return false;
            }
            throw new RuntimeException("Couldn't connect to opensearch due to IOExceptionError", ioException);
        }
        catch (ElasticsearchException elasticsearchException) {
            if (elasticsearchException.status().getStatus() >= 500) {
                logger.debug("OpenSearch health request ended with HTTP status code {}. Is OpenSearch service running?", (Object)elasticsearchException.status().getStatus());
                return false;
            }
            logger.error("Error while testing OpenSearch connection", (Throwable)elasticsearchException);
            throw elasticsearchException;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to connect to OpenSearch, unexpected exception", e);
        }
    }

    protected void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    private void createIndex() throws SearchIndexException, IOException {
        if (StringUtils.isBlank((CharSequence)this.indexIdentifier)) {
            throw new IllegalArgumentException("Search index identifier must be set");
        }
        for (String type : this.getDocumentTypes()) {
            this.createSubIndex(type, this.getSubIndexIdentifier(type));
        }
    }

    private void createSubIndex(String type, String idxName) throws SearchIndexException, IOException {
        try {
            logger.debug("Trying to create index for '{}'", (Object)idxName);
            CreateIndexRequest request = new CreateIndexRequest(idxName).settings(this.loadResources("indexSettings.json"), XContentType.JSON).mapping(this.loadResources(type + "-mapping.json"), XContentType.JSON);
            CreateIndexResponse siteIdxResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
            if (!siteIdxResponse.isAcknowledged()) {
                throw new SearchIndexException("Unable to create index for '" + idxName + "'");
            }
        }
        catch (ElasticsearchStatusException e) {
            if (e.getDetailedMessage().contains("already_exists_exception")) {
                logger.info("Detected existing index '{}'", (Object)idxName);
            }
            throw e;
        }
        boolean versionIndexExists = false;
        GetRequest getRequest = new GetRequest(idxName, ROOT_ID);
        try {
            GetResponse getResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
            if (getResponse.isExists() && getResponse.getField("version") != null) {
                int actualIndexVersion = Integer.parseInt(getResponse.getField("version").getValue().toString());
                if (this.indexVersion != actualIndexVersion) {
                    throw new SearchIndexException("Search index is at version " + actualIndexVersion + ", but codebase expects " + this.indexVersion);
                }
                versionIndexExists = true;
                logger.debug("Search index version is {}", (Object)this.indexVersion);
            }
        }
        catch (ElasticsearchException e) {
            logger.debug("Version index has not been created");
        }
        if (!versionIndexExists) {
            logger.debug("Creating version index for site '{}'", (Object)idxName);
            IndexRequest indexRequest = new IndexRequest(idxName).id(ROOT_ID).source(Collections.singletonMap("version", "" + this.indexVersion));
            logger.debug("Index version of site '{}' is {}", (Object)idxName, (Object)this.indexVersion);
            this.client.index(indexRequest, RequestOptions.DEFAULT);
        }
    }

    private String loadResources(String filename) throws IOException {
        String resourcePath = "/elasticsearch/" + filename;
        for (Class cls : Arrays.asList(this.getClass(), AbstractElasticsearchIndex.class)) {
            InputStream is = cls.getResourceAsStream(resourcePath);
            try {
                if (is == null) continue;
                String settings = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                logger.debug("Reading elasticsearch configuration resources from {}:\n{}", (Object)cls, (Object)settings);
                String string = settings;
                return string;
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return null;
    }

    protected SearchRequest getSearchRequest(SearchQuery query, QueryBuilder queryBuilder) {
        SearchSourceBuilder searchSource = new SearchSourceBuilder().query(queryBuilder).trackTotalHits(true);
        logger.debug("Searching for {}", (Object)searchSource);
        if (query.getFields().length > 0) {
            searchSource.storedFields(Arrays.asList(query.getFields()));
        } else {
            searchSource.storedFields(Collections.singletonList("*"));
        }
        if (query.getOffset() >= 0) {
            searchSource.from(query.getOffset());
        }
        int limit = Integer.MAX_VALUE;
        if (query.getLimit() > 0) {
            limit = query.getOffset() > 0 && (long)query.getOffset() + (long)query.getLimit() > Integer.MAX_VALUE ? Integer.MAX_VALUE - query.getOffset() : query.getLimit();
        }
        searchSource.size(limit);
        Map sortCriteria = query.getSortOrders();
        for (Map.Entry sortCriterion : sortCriteria.entrySet()) {
            ScriptSortBuilder sortBuilder = null;
            logger.debug("Event sort criteria: {}", sortCriterion.getKey());
            if ("publication".equals(sortCriterion.getKey())) {
                sortBuilder = SortBuilders.scriptSort((Script)new Script("params._source.publication.length"), (ScriptSortBuilder.ScriptSortType)ScriptSortBuilder.ScriptSortType.NUMBER);
            }
            switch ((SortCriterion.Order)sortCriterion.getValue()) {
                case Ascending: {
                    if (sortBuilder != null) {
                        sortBuilder.order(SortOrder.ASC);
                        searchSource.sort((SortBuilder)sortBuilder);
                        break;
                    }
                    searchSource.sort((String)sortCriterion.getKey(), SortOrder.ASC);
                    break;
                }
                case Descending: {
                    if (sortBuilder != null) {
                        sortBuilder.order(SortOrder.DESC);
                        searchSource.sort((SortBuilder)sortBuilder);
                        break;
                    }
                    searchSource.sort((String)sortCriterion.getKey(), SortOrder.DESC);
                    break;
                }
            }
        }
        return new SearchRequest((String[])Arrays.stream(query.getTypes()).map(this::getSubIndexIdentifier).toArray(String[]::new)).searchType(SearchType.QUERY_THEN_FETCH).preference("_local").source(searchSource);
    }

    public String getIndexName() {
        return this.indexName;
    }

    protected long getTotalHits(SearchHits hits) {
        return hits.getTotalHits().value;
    }

    protected String getSubIndexIdentifier(String type) {
        return this.indexIdentifier + "_" + type;
    }

    public RestHighLevelClient getClient() {
        return this.client;
    }

    protected <T> SearchResult<T> executeQuery(SearchQuery query, SearchRequest request, Function<SearchMetadataCollection, T> toSearchResult, int maxRetryAttempts, int retryWaitingPeriod) throws IOException, InterruptedException {
        SearchResponse searchResponse = null;
        int retryAttempts = 0;
        do {
            try {
                searchResponse = this.getClient().search(request, RequestOptions.DEFAULT);
            }
            catch (ElasticsearchStatusException e) {
                if (++retryAttempts <= maxRetryAttempts) {
                    logger.warn("Could not query documents from index {} because of {}, retrying in {} ms.", new Object[]{this.getIndexName(), e.getMessage(), retryWaitingPeriod});
                    if (retryWaitingPeriod <= 0) continue;
                    Thread.sleep(retryWaitingPeriod);
                    continue;
                }
                logger.error("Could not query documents from index {}, not retrying.", (Object)this.getIndexName(), (Object)e);
                throw e;
            }
        } while (searchResponse == null);
        long hits = this.getTotalHits(searchResponse.getHits());
        long size = searchResponse.getHits().getHits().length;
        SearchResultImpl<T> result = new SearchResultImpl<T>(query, hits, size);
        result.setSearchTime(searchResponse.getTook().millis());
        for (SearchHit doc : searchResponse.getHits()) {
            SearchMetadataCollection metadata = new SearchMetadataCollection(doc.getType());
            metadata.setIdentifier(doc.getId());
            for (DocumentField field : doc.getFields().values()) {
                String name = field.getName();
                SearchMetadataImpl m = new SearchMetadataImpl(name);
                if (field.getValues().size() > 1) {
                    for (Object v : field.getValues()) {
                        m.addValue(v);
                    }
                } else {
                    m.addValue(field.getValue());
                }
                metadata.add(m);
            }
            float score = doc.getScore();
            try {
                T document = toSearchResult.apply(metadata);
                SearchResultItemImpl<T> item = new SearchResultItemImpl<T>(score, document);
                result.addResultItem(item);
            }
            catch (Throwable t) {
                logger.warn("Error during search result serialization: '{}'. Skipping this search result.", (Object)t.getMessage());
                --size;
            }
        }
        result.setDocumentCount(size);
        return result;
    }

    private String getOpensearchURL() {
        return this.externalServerScheme + "://" + this.externalServerHostname + ":" + this.externalServerPort;
    }

    public List<String> getTermsForField(String field, String type) {
        String facetName = "terms";
        TermsAggregationBuilder aggBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"terms").field(field)).size(10000);
        SearchSourceBuilder searchSource = new SearchSourceBuilder().aggregation((AggregationBuilder)aggBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getSubIndexIdentifier(type)}).source(searchSource);
        try {
            SearchResponse response = this.getClient().search(searchRequest, RequestOptions.DEFAULT);
            ArrayList<String> terms = new ArrayList<String>();
            Terms aggs = (Terms)response.getAggregations().get("terms");
            for (Terms.Bucket bucket : aggs.getBuckets()) {
                terms.add(bucket.getKey().toString());
            }
            return terms;
        }
        catch (IOException e) {
            return (List)Misc.chuck((Throwable)e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$init$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

