/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Point;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.spatial.prefix.tree.S2ShapeFactory;
import org.apache.lucene.spatial.spatial4j.Geo3dCircleShape;
import org.apache.lucene.spatial.spatial4j.Geo3dPointShape;
import org.apache.lucene.spatial.spatial4j.Geo3dRectangleShape;
import org.apache.lucene.spatial.spatial4j.Geo3dShape;
import org.apache.lucene.spatial.spatial4j.Geo3dSpatialContextFactory;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.lucene.spatial3d.geom.GeoCircleFactory;
import org.apache.lucene.spatial3d.geom.GeoCompositeAreaShape;
import org.apache.lucene.spatial3d.geom.GeoPath;
import org.apache.lucene.spatial3d.geom.GeoPathFactory;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPointShape;
import org.apache.lucene.spatial3d.geom.GeoPointShapeFactory;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.GeoPolygonFactory;
import org.apache.lucene.spatial3d.geom.GeoS2ShapeFactory;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.ShapeFactory;

public class Geo3dShapeFactory
implements S2ShapeFactory {
    private final boolean normWrapLongitude;
    private SpatialContext context;
    private PlanetModel planetModel;
    private static final double DEFAULT_CIRCLE_ACCURACY = 1.0E-4;
    private double circleAccuracy = 1.0E-4;

    public Geo3dShapeFactory(SpatialContext context, SpatialContextFactory factory) {
        this.context = context;
        this.planetModel = ((Geo3dSpatialContextFactory)factory).planetModel;
        this.normWrapLongitude = context.isGeo() && factory.normWrapLongitude;
    }

    public SpatialContext getSpatialContext() {
        return this.context;
    }

    public void setCircleAccuracy(double circleAccuracy) {
        this.circleAccuracy = circleAccuracy;
    }

    public boolean isNormWrapLongitude() {
        return this.normWrapLongitude;
    }

    public double normX(double x) {
        if (this.normWrapLongitude) {
            x = DistanceUtils.normLonDEG((double)x);
        }
        return x;
    }

    public double normY(double y) {
        return y;
    }

    public double normZ(double z) {
        return z;
    }

    public double normDist(double distance) {
        return distance;
    }

    public void verifyX(double x) {
        Rectangle bounds = this.context.getWorldBounds();
        if (x < bounds.getMinX() || x > bounds.getMaxX()) {
            throw new InvalidShapeException("Bad X value " + x + " is not in boundary " + bounds);
        }
    }

    public void verifyY(double y) {
        Rectangle bounds = this.context.getWorldBounds();
        if (y < bounds.getMinY() || y > bounds.getMaxY()) {
            throw new InvalidShapeException("Bad Y value " + y + " is not in boundary " + bounds);
        }
    }

    public void verifyZ(double v) {
    }

    public Point pointXY(double x, double y) {
        GeoPointShape point = GeoPointShapeFactory.makeGeoPointShape(this.planetModel, y * (Math.PI / 180), x * (Math.PI / 180));
        return new Geo3dPointShape(point, this.context);
    }

    public Point pointXYZ(double x, double y, double z) {
        GeoPoint point = new GeoPoint(x, y, z);
        GeoPointShape pointShape = GeoPointShapeFactory.makeGeoPointShape(this.planetModel, point.getLatitude(), point.getLongitude());
        return new Geo3dPointShape(pointShape, this.context);
    }

    public Rectangle rect(Point point, Point point1) {
        return this.rect(point.getX(), point1.getX(), point.getY(), point1.getY());
    }

    public Rectangle rect(double minX, double maxX, double minY, double maxY) {
        GeoBBox bBox = GeoBBoxFactory.makeGeoBBox(this.planetModel, maxY * (Math.PI / 180), minY * (Math.PI / 180), minX * (Math.PI / 180), maxX * (Math.PI / 180));
        return new Geo3dRectangleShape(bBox, this.context, minX, maxX, minY, maxY);
    }

    public Circle circle(double x, double y, double distance) {
        GeoCircle circle = this.planetModel.isSphere() ? GeoCircleFactory.makeGeoCircle(this.planetModel, y * (Math.PI / 180), x * (Math.PI / 180), distance * (Math.PI / 180)) : GeoCircleFactory.makeExactGeoCircle(this.planetModel, y * (Math.PI / 180), x * (Math.PI / 180), distance * (Math.PI / 180), this.circleAccuracy * (Math.PI / 180));
        return new Geo3dCircleShape(circle, this.context);
    }

    public Circle circle(Point point, double distance) {
        return this.circle(point.getX(), point.getY(), distance);
    }

    public Shape lineString(List<Point> list, double distance) {
        ShapeFactory.LineStringBuilder builder = this.lineString();
        for (Point point : list) {
            builder.pointXY(point.getX(), point.getY());
        }
        builder.buffer(distance);
        return builder.build();
    }

    public <S extends Shape> ShapeCollection<S> multiShape(List<S> list) {
        throw new UnsupportedOperationException();
    }

    public ShapeFactory.LineStringBuilder lineString() {
        return new Geo3dLineStringBuilder();
    }

    public ShapeFactory.PolygonBuilder polygon() {
        return new Geo3dPolygonBuilder();
    }

    public <T extends Shape> ShapeFactory.MultiShapeBuilder<T> multiShape(Class<T> aClass) {
        return new Geo3dMultiShapeBuilder();
    }

    public ShapeFactory.MultiPointBuilder multiPoint() {
        return new Geo3dMultiPointBuilder();
    }

    public ShapeFactory.MultiLineStringBuilder multiLineString() {
        return new Geo3dMultiLineBuilder();
    }

    public ShapeFactory.MultiPolygonBuilder multiPolygon() {
        return new Geo3dMultiPolygonBuilder();
    }

    @Override
    public Shape getS2CellShape(S2CellId cellId) {
        S2Cell cell = new S2Cell(cellId);
        GeoPoint point1 = this.getGeoPoint(cell.getVertexRaw(0));
        GeoPoint point2 = this.getGeoPoint(cell.getVertexRaw(1));
        GeoPoint point3 = this.getGeoPoint(cell.getVertexRaw(2));
        GeoPoint point4 = this.getGeoPoint(cell.getVertexRaw(3));
        return new Geo3dShape<GeoPolygon>(GeoS2ShapeFactory.makeGeoS2Shape(this.planetModel, point1, point2, point3, point4), this.context);
    }

    private GeoPoint getGeoPoint(S2Point point) {
        return this.planetModel.createSurfacePoint(point.get(0), point.get(1), point.get(2));
    }

    private class Geo3dMultiShapeBuilder<T extends Shape>
    implements ShapeFactory.MultiShapeBuilder<T> {
        GeoCompositeAreaShape composite;

        private Geo3dMultiShapeBuilder() {
            this.composite = new GeoCompositeAreaShape(Geo3dShapeFactory.this.planetModel);
        }

        public ShapeFactory.MultiShapeBuilder<T> add(T shape) {
            Geo3dShape areaShape = (Geo3dShape)shape;
            this.composite.addShape(areaShape.shape);
            return this;
        }

        public Shape build() {
            return new Geo3dShape<GeoCompositeAreaShape>(this.composite, Geo3dShapeFactory.this.context);
        }
    }

    private class Geo3dMultiPolygonBuilder
    implements ShapeFactory.MultiPolygonBuilder {
        List<ShapeFactory.PolygonBuilder> builders = new ArrayList<ShapeFactory.PolygonBuilder>();

        private Geo3dMultiPolygonBuilder() {
        }

        public ShapeFactory.PolygonBuilder polygon() {
            return new Geo3dPolygonBuilder();
        }

        public ShapeFactory.MultiPolygonBuilder add(ShapeFactory.PolygonBuilder polygonBuilder) {
            this.builders.add(polygonBuilder);
            return this;
        }

        public Shape build() {
            GeoCompositeAreaShape areaShape = new GeoCompositeAreaShape(Geo3dShapeFactory.this.planetModel);
            for (ShapeFactory.PolygonBuilder builder : this.builders) {
                Geo3dShape shape = (Geo3dShape)builder.build();
                areaShape.addShape(shape.shape);
            }
            return new Geo3dShape<GeoCompositeAreaShape>(areaShape, Geo3dShapeFactory.this.context);
        }
    }

    private class Geo3dMultiLineBuilder
    implements ShapeFactory.MultiLineStringBuilder {
        List<ShapeFactory.LineStringBuilder> builders = new ArrayList<ShapeFactory.LineStringBuilder>();

        private Geo3dMultiLineBuilder() {
        }

        public ShapeFactory.LineStringBuilder lineString() {
            return new Geo3dLineStringBuilder();
        }

        public ShapeFactory.MultiLineStringBuilder add(ShapeFactory.LineStringBuilder lineStringBuilder) {
            this.builders.add(lineStringBuilder);
            return this;
        }

        public Shape build() {
            GeoCompositeAreaShape areaShape = new GeoCompositeAreaShape(Geo3dShapeFactory.this.planetModel);
            for (ShapeFactory.LineStringBuilder builder : this.builders) {
                Geo3dShape shape = (Geo3dShape)builder.build();
                areaShape.addShape(shape.shape);
            }
            return new Geo3dShape<GeoCompositeAreaShape>(areaShape, Geo3dShapeFactory.this.context);
        }
    }

    private class Geo3dMultiPointBuilder
    extends Geo3dPointBuilder<ShapeFactory.MultiPointBuilder>
    implements ShapeFactory.MultiPointBuilder {
        private Geo3dMultiPointBuilder() {
        }

        public Shape build() {
            GeoCompositeAreaShape areaShape = new GeoCompositeAreaShape(Geo3dShapeFactory.this.planetModel);
            for (GeoPoint point : this.points) {
                GeoPointShape pointShape = GeoPointShapeFactory.makeGeoPointShape(Geo3dShapeFactory.this.planetModel, point.getLatitude(), point.getLongitude());
                areaShape.addShape(pointShape);
            }
            return new Geo3dShape<GeoCompositeAreaShape>(areaShape, Geo3dShapeFactory.this.context);
        }
    }

    private class Geo3dPolygonBuilder
    extends Geo3dPointBuilder<ShapeFactory.PolygonBuilder>
    implements ShapeFactory.PolygonBuilder {
        List<GeoPolygonFactory.PolygonDescription> polyHoles;

        private Geo3dPolygonBuilder() {
            this.polyHoles = new ArrayList<GeoPolygonFactory.PolygonDescription>();
        }

        public ShapeFactory.PolygonBuilder.HoleBuilder hole() {
            return new Geo3dHoleBuilder();
        }

        public Shape build() {
            GeoPolygonFactory.PolygonDescription description = new GeoPolygonFactory.PolygonDescription(this.points, this.polyHoles);
            GeoPolygon polygon = GeoPolygonFactory.makeGeoPolygon(Geo3dShapeFactory.this.planetModel, description);
            if (polygon == null) {
                throw new InvalidShapeException("Invalid polygon, all points are coplanar");
            }
            return new Geo3dShape<GeoPolygon>(polygon, Geo3dShapeFactory.this.context);
        }

        public Shape buildOrRect() {
            return this.build();
        }

        class Geo3dHoleBuilder
        extends Geo3dPointBuilder<ShapeFactory.PolygonBuilder.HoleBuilder>
        implements ShapeFactory.PolygonBuilder.HoleBuilder {
            Geo3dHoleBuilder() {
            }

            public ShapeFactory.PolygonBuilder endHole() {
                Geo3dPolygonBuilder.this.polyHoles.add(new GeoPolygonFactory.PolygonDescription(this.points));
                return Geo3dPolygonBuilder.this;
            }
        }
    }

    private class Geo3dLineStringBuilder
    extends Geo3dPointBuilder<ShapeFactory.LineStringBuilder>
    implements ShapeFactory.LineStringBuilder {
        double distance;

        private Geo3dLineStringBuilder() {
            this.distance = 0.0;
        }

        public ShapeFactory.LineStringBuilder buffer(double distance) {
            this.distance = distance;
            return this;
        }

        public Shape build() {
            GeoPath path = GeoPathFactory.makeGeoPath(Geo3dShapeFactory.this.planetModel, this.distance, this.points.toArray(new GeoPoint[this.points.size()]));
            return new Geo3dShape<GeoPath>(path, Geo3dShapeFactory.this.context);
        }
    }

    private class Geo3dPointBuilder<T>
    implements ShapeFactory.PointsBuilder<T> {
        List<GeoPoint> points = new ArrayList<GeoPoint>();

        private Geo3dPointBuilder() {
        }

        public T pointXY(double x, double y) {
            GeoPoint point = new GeoPoint(Geo3dShapeFactory.this.planetModel, y * (Math.PI / 180), x * (Math.PI / 180));
            this.points.add(point);
            return (T)this;
        }

        public T pointXYZ(double x, double y, double z) {
            GeoPoint point = new GeoPoint(x, y, z);
            if (!this.points.contains(point)) {
                this.points.add(point);
            }
            return (T)this;
        }
    }
}

