/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class TokenGroup {
    private static final int MAX_NUM_TOKENS_PER_GROUP = 50;
    private float[] scores = new float[50];
    private int numTokens = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private float tot;
    private int matchStartOffset;
    private int matchEndOffset;
    private OffsetAttribute offsetAtt;
    private CharTermAttribute termAtt;

    public TokenGroup(TokenStream tokenStream) {
        this.offsetAtt = tokenStream.addAttribute(OffsetAttribute.class);
        this.termAtt = tokenStream.addAttribute(CharTermAttribute.class);
    }

    void addToken(float score) {
        if (this.numTokens < 50) {
            int termStartOffset = this.offsetAtt.startOffset();
            int termEndOffset = this.offsetAtt.endOffset();
            if (this.numTokens == 0) {
                this.startOffset = this.matchStartOffset = termStartOffset;
                this.endOffset = this.matchEndOffset = termEndOffset;
                this.tot += score;
            } else {
                this.startOffset = Math.min(this.startOffset, termStartOffset);
                this.endOffset = Math.max(this.endOffset, termEndOffset);
                if (score > 0.0f) {
                    if (this.tot == 0.0f) {
                        this.matchStartOffset = termStartOffset;
                        this.matchEndOffset = termEndOffset;
                    } else {
                        this.matchStartOffset = Math.min(this.matchStartOffset, termStartOffset);
                        this.matchEndOffset = Math.max(this.matchEndOffset, termEndOffset);
                    }
                    this.tot += score;
                }
            }
            this.scores[this.numTokens] = score;
            ++this.numTokens;
        }
    }

    boolean isDistinct() {
        return this.offsetAtt.startOffset() >= this.endOffset;
    }

    void clear() {
        this.numTokens = 0;
        this.tot = 0.0f;
    }

    public float getScore(int index) {
        return this.scores[index];
    }

    public int getStartOffset() {
        return this.matchStartOffset;
    }

    public int getEndOffset() {
        return this.matchEndOffset;
    }

    public int getNumTokens() {
        return this.numTokens;
    }

    public float getTotalScore() {
        return this.tot;
    }
}

