/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.impl;

import java.util.ArrayList;
import java.util.List;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;

public class SearchResultImpl<T>
implements SearchResult<T> {
    protected SearchQuery query = null;
    protected long offset = 0L;
    protected long limit = 0L;
    protected long hitCount = 0L;
    protected long documentCount = 0L;
    protected long time = 0L;
    protected List<SearchResultItem<T>> result = null;

    public SearchResultImpl(SearchQuery query, long hitCount, long documentCount) {
        this.query = query;
        this.offset = query.getOffset();
        this.limit = query.getLimit();
        this.hitCount = hitCount;
        this.documentCount = documentCount;
    }

    public void addResultItem(SearchResultItem<T> item) {
        if (this.result == null) {
            this.result = new ArrayList<SearchResultItem<T>>();
        }
        this.result.add(item);
    }

    public SearchResultItem<T>[] getItems() {
        if (this.result == null) {
            return new SearchResultItem[0];
        }
        return this.result.toArray(new SearchResultItem[this.result.size()]);
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getPage() {
        if (this.offset == 0L || this.limit == 0L) {
            return 1L;
        }
        return (long)Math.floor(this.offset / this.limit) + 1L;
    }

    public long getPageSize() {
        return this.result != null ? (long)this.result.size() : 0L;
    }

    public SearchQuery getQuery() {
        return this.query;
    }

    public void setSearchTime(long time) {
        this.time = time;
    }

    public long getSearchTime() {
        return this.time;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getDocumentCount() {
        return this.result != null ? (long)this.result.size() : this.documentCount;
    }

    public void setDocumentCount(long count) {
        this.documentCount = count;
    }
}

